/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.jnlp.ui;

import com.sun.portal.netlet.client.common.ResourceProperties;
import com.sun.portal.netlet.client.jnlp.ClientManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class NetletTab
extends JPanel {
    JButton startButton;
    JButton stopButton;
    private GridBagConstraints gbc = new GridBagConstraints();

    public NetletTab() {
        super(new GridBagLayout());
        this.gbc.fill = 2;
        this.gbc.weightx = 0.5;
        this.load();
    }

    private void load() {
        if (ClientManager.getNetletHandler().netletClientRuning()) {
            this.gbc.gridx = 0;
            this.gbc.gridy = 0;
            this.add((Component)this.getClientPortsPane(), this.gbc);
            this.gbc.gridx = 0;
            this.gbc.gridy = 1;
            this.add((Component)this.getButtonPane(), this.gbc);
        } else {
            this.gbc.gridx = 0;
            this.gbc.gridy = 0;
            this.add((Component)this.getNetletTextPane(ResourceProperties.getString("jws.netletNotRunning")), this.gbc);
            this.gbc.gridx = 0;
            this.gbc.gridy = 1;
            this.add((Component)this.getButtonPane(), this.gbc);
        }
    }

    private JComponent getClientPortsPane() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(ResourceProperties.getString("portinfo.2"));
        columnNames.add(ResourceProperties.getString("portinfo.3"));
        columnNames.add(ResourceProperties.getString("portinfo.4"));
        Vector dataRows = new Vector();
        Hashtable clientPorts = ClientManager.getNetletHandler().getClientPorts();
        Enumeration ruleNames = clientPorts.keys();
        while (ruleNames.hasMoreElements()) {
            String ruleName = (String)ruleNames.nextElement();
            Vector<String> dataRow = new Vector<String>();
            Vector v = (Vector)clientPorts.get(ruleName);
            Enumeration values = v.elements();
            while (values.hasMoreElements()) {
                String s = (String)values.nextElement();
                if (s.indexOf(":") == -1) continue;
                String targetPort = s.substring(0, s.indexOf(":"));
                String clientPort = s.substring(s.indexOf(":") + 1);
                dataRow.add(ruleName);
                dataRow.add(targetPort);
                dataRow.add(clientPort);
            }
            dataRows.add(dataRow);
        }
        JTable table = new JTable(dataRows, columnNames);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setPreferredSize(new Dimension(350, 150));
        return scrollPane;
    }

    protected JComponent getNetletTextPane(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(new Dimension(350, 150));
        label.setHorizontalAlignment(0);
        label.setVerticalTextPosition(0);
        label.setVerticalAlignment(0);
        return label;
    }

    private JComponent getButtonPane() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        ButtonActionListener listner = new ButtonActionListener();
        this.startButton = new JButton(ResourceProperties.getString("jws.startNetlet"));
        this.startButton.addActionListener(listner);
        this.startButton.setActionCommand("Start");
        this.stopButton = new JButton(ResourceProperties.getString("jws.stopNetlet"));
        this.stopButton.addActionListener(listner);
        this.stopButton.setActionCommand("Stop");
        if (ClientManager.getNetletHandler().netletClientRuning()) {
            this.startButton.setEnabled(false);
            this.stopButton.setEnabled(true);
        } else {
            this.startButton.setEnabled(true);
            this.stopButton.setEnabled(false);
        }
        buttonPanel.add(this.startButton);
        buttonPanel.add(this.stopButton);
        return buttonPanel;
    }

    public void refresh() {
        this.removeAll();
        this.load();
        ClientManager.getSRAClientWindow().pack();
    }

    class ButtonActionListener
    implements ActionListener {
        ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equalsIgnoreCase("Start")) {
                System.out.println("Netlet Start Clicked");
                NetletTab.this.startButton.setEnabled(false);
                ClientManager.getNetletHandler().startClient();
                NetletTab.this.stopButton.setEnabled(true);
            } else if (e.getActionCommand().equalsIgnoreCase("Stop")) {
                System.out.println("Netlet Stop Clicked");
                NetletTab.this.stopButton.setEnabled(false);
                ClientManager.getNetletHandler().stopClient(true);
                NetletTab.this.startButton.setEnabled(true);
            }
            NetletTab.this.refresh();
        }
    }
}

