/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.jnlp.connect;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Cookie {
    public static String SET_COOKIE_FORMAT = "SET_COOKIE_FORMAT";
    public static String APPLETPARAM_COOKIE_FORMAT = "APPLETPARAM_COOKIE_FORMAT";
    private String name;
    private String value;
    private String domain;
    private String pathPattern;
    private String rawCookie;
    private Hashtable cookieList = new Hashtable();
    private String pattern;

    public Cookie() {
    }

    public Cookie(String cookie, String pattern) {
        this.rawCookie = cookie;
        this.pattern = pattern;
        this.format();
    }

    public void format() {
        if (this.rawCookie == null) {
            return;
        }
        if (this.pattern.equals(SET_COOKIE_FORMAT)) {
            this.parseCookie();
        } else if (this.pattern.equals(APPLETPARAM_COOKIE_FORMAT)) {
            this.parseMulCookie();
        }
    }

    private void parseMulCookie() {
        StringTokenizer st = new StringTokenizer(this.rawCookie, ";");
        String elem = null;
        String val = null;
        while (st.hasMoreTokens()) {
            String nvpair = st.nextToken();
            int index = nvpair.indexOf(61);
            if (index == -1) continue;
            elem = nvpair.substring(0, index);
            val = nvpair.substring(index + 1, nvpair.length());
            this.cookieList.put(elem, val);
        }
    }

    private void parseCookie() {
        StringTokenizer st = new StringTokenizer(this.rawCookie, ";");
        while (st.hasMoreTokens()) {
            String nvpair = st.nextToken();
            int index = nvpair.indexOf(61);
            String elem = nvpair.substring(0, index);
            String val = nvpair.substring(index + 1, nvpair.length());
            if (elem.equals("Domain")) {
                this.domain = val;
                continue;
            }
            if (elem.equals("Path")) {
                this.pathPattern = val;
                continue;
            }
            this.name = elem;
            this.value = val;
        }
    }

    public String getCookieHeaderField() {
        return this.getName() + "=" + this.getValue();
    }

    public boolean mayBeSent(String host, String path) {
        if (this.getDomain() != null && (host.equalsIgnoreCase(this.getDomain()) || host.endsWith(this.getDomain()))) {
            if (this.pathPattern == null) {
                return true;
            }
            if (path.startsWith(this.pathPattern)) {
                return true;
            }
        }
        return false;
    }

    public static Cookie getCookieByName(String cookieName, Vector cookieMulLine) {
        String ctemp = "";
        Cookie ccookie = null;
        Cookie retcookie = null;
        if (cookieMulLine != null && !cookieMulLine.isEmpty()) {
            Iterator icookieMulLine = cookieMulLine.iterator();
            while (icookieMulLine.hasNext()) {
                String cookieLine = (String)icookieMulLine.next();
                ccookie = new Cookie(cookieLine, SET_COOKIE_FORMAT);
                if (!ccookie.getName().equals(cookieName)) continue;
                retcookie = ccookie;
                break;
            }
        }
        return retcookie;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.pathPattern;
    }

    public String getName() {
        if (this.pattern.equals(SET_COOKIE_FORMAT)) {
            return this.name;
        }
        return "iPlanetDirectoryPro";
    }

    public String getValue() {
        if (this.pattern.equals(SET_COOKIE_FORMAT)) {
            return this.value;
        }
        Enumeration vals = this.cookieList.elements();
        String value = null;
        Enumeration e = this.cookieList.keys();
        while (e.hasMoreElements()) {
            String temp = ((String)e.nextElement()).trim();
            value = ((String)vals.nextElement()).trim();
            if (!temp.equals("iPlanetDirectoryPro")) continue;
            break;
        }
        return value;
    }

    public String getOriginalCookie() {
        return this.rawCookie;
    }
}

