/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.jnlp.connect;

import com.sun.portal.netlet.client.jnlp.ClientManager;
import com.sun.portal.netlet.client.jnlp.connect.ClientListener;
import com.sun.portal.netlet.client.jnlp.connect.HTTPFields;
import com.sun.portal.netlet.client.jnlp.connect.HTTPRequestStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URLDecoder;

public class ConnectionHandler {
    private ClientListener parent = null;
    private Socket connection = null;

    public ConnectionHandler(Socket clntSocket, ClientListener parent) {
        this.connection = clntSocket;
        this.parent = parent;
        this.handleConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleConnection() {
        try {
            HTTPRequestStream clientIn = new HTTPRequestStream(this.connection.getInputStream());
            OutputStream clientOut = this.connection.getOutputStream();
            HTTPFields reqFields = new HTTPFields();
            reqFields.read(clientIn);
            String firstLine = reqFields.getFirstLine();
            System.out.println("ConnectionHandler firstLine " + firstLine);
            int index = firstLine.lastIndexOf(" ");
            reqFields.setHttpVersion(firstLine.substring(index, firstLine.length()).trim());
            if (firstLine.indexOf("/startNetlet") != -1) {
                this.handleNetletRequest(reqFields, clientOut);
                clientIn.close();
                clientOut.close();
                return;
            }
            if (firstLine.indexOf("/startProxylet") != -1) {
                this.handleProxyletRequest(reqFields, clientOut);
                clientIn.close();
                clientOut.close();
                return;
            }
            if (firstLine.indexOf("/UI/Logout") == -1) return;
            return;
        }
        catch (MalformedURLException me) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        catch (Exception ignore) {
            return;
        }
        finally {
            try {
                this.connection.close();
            }
            catch (Exception e) {}
        }
    }

    private void handleNetletRequest(HTTPFields reqFields, OutputStream clientOut) throws IOException {
        ClientManager.getNetletHandler().startClient();
        this.sendRedirectResponse(reqFields, clientOut);
    }

    private void handleProxyletRequest(HTTPFields reqFields, OutputStream clientOut) throws IOException {
        byte[] header = this.getHeader(0, reqFields.getHttpVersion());
        clientOut.write(header);
        clientOut.flush();
    }

    private byte[] getHeader(int contentLength, String httpVersion) {
        String dummyHeader = httpVersion + " " + 200 + " " + "OK" + "\n" + "Content-Type: text/html" + "\n" + "Connection: close" + "\n" + "Content-Length: " + contentLength + "\n\r\n\r";
        return dummyHeader.getBytes();
    }

    private void sendRedirectResponse(HTTPFields reqFields, OutputStream clientOut) throws IOException {
        String codebaseURL;
        String redirectURL = reqFields.getRedirectURL();
        redirectURL = URLDecoder.decode(redirectURL);
        System.out.println("redirectURL " + redirectURL);
        String gwURL = ClientManager.getParam("gwURL");
        System.out.println("GWURL " + gwURL);
        if (redirectURL.startsWith("/") && (codebaseURL = ClientManager.getCodeBaseUrl()) != null && codebaseURL.length() > 0) {
            int hostIndex = codebaseURL.indexOf("/");
            int portIndex = codebaseURL.indexOf("/", hostIndex + 2);
            redirectURL = gwURL + codebaseURL.substring(0, portIndex) + redirectURL;
        }
        System.out.println("ConnectionHandler.sendRedirectResponse redirectURL " + redirectURL);
        String content = "File Moved temporarily";
        String respHeader_302 = reqFields.getHttpVersion() + " " + 302 + " " + "Moved Temporarily" + "\n" + "Content-Type: text/html; charset=UTF-8" + "\n" + "Location: " + redirectURL + "\n" + "Connection: close" + "\n" + "Content-Length: " + content.length() + "\n\r\n\r";
        clientOut.write(respHeader_302.getBytes());
        clientOut.write(content.getBytes());
        clientOut.flush();
    }
}

