/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.jnlp.connect;

import com.sun.portal.netlet.client.jnlp.ClientManager;
import com.sun.portal.netlet.client.jnlp.connect.ConnectionHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class ClientListener
implements Runnable {
    private Socket inconnection;
    private ServerSocket sconnection = null;
    private Thread thread = null;
    private boolean socketOpened;
    private int srcPort;

    public ClientListener(int srcPort) {
        this.srcPort = srcPort;
    }

    public void start() {
        if (this.sconnection == null) {
            this.sconnection = this.makeServerSocket();
        }
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void run() {
        System.out.println("ClientListener run");
        while (this.socketOpened) {
            block12: {
                if (this.sconnection == null) {
                    this.socketOpened = false;
                    continue;
                }
                try {
                    this.inconnection = this.sconnection.accept();
                }
                catch (IOException e) {
                    try {
                        this.sconnection.close();
                        Thread.sleep(5L);
                        if (!this.socketOpened) {
                            break;
                        }
                    }
                    catch (IOException ee) {
                        System.out.println("SClient serversocket accept problem close error:");
                        ee.printStackTrace();
                    }
                    catch (InterruptedException ee) {
                    }
                    catch (NullPointerException ee) {
                        return;
                    }
                    if (!this.socketOpened) break block12;
                    this.sconnection = this.makeServerSocket();
                    continue;
                }
            }
            try {
                this.inconnection.setTcpNoDelay(true);
            }
            catch (SocketException e) {
                System.out.println("SClient accept socket error setting tcpNoDelay");
                e.printStackTrace();
                this.socketOpened = false;
            }
            if (this.inconnection == null) continue;
            System.out.println("Client Listener got connection on port: " + this.inconnection.getLocalPort() + " from port:" + this.inconnection.getPort());
            new ConnectionHandler(this.inconnection, this);
        }
        this.close();
    }

    private ServerSocket makeServerSocket() {
        ServerSocket sock = null;
        boolean go = true;
        int retries = 5;
        String clientBindIP = ClientManager.getParam("clientBindIP");
        while (go) {
            try {
                InetAddress bindAddr = null;
                bindAddr = InetAddress.getByName(clientBindIP);
                sock = new ServerSocket(this.srcPort, 10, bindAddr);
                this.srcPort = sock.getLocalPort();
                go = false;
                this.socketOpened = true;
                System.out.println("ClientListener: server socket opened at port " + this.srcPort + " and host " + clientBindIP);
            }
            catch (UnknownHostException uhe) {
                System.out.println("ClientListener:Unable to make server socket at port " + this.srcPort + " and host " + clientBindIP + " " + uhe);
                sock = null;
                this.srcPort = 0;
                go = false;
            }
            catch (IOException ioe) {
                System.out.println("ClientListener: Unable to make server socket at port " + this.srcPort + " and host " + clientBindIP + " " + ioe);
                sock = null;
                this.srcPort = 0;
                go = retries > 0;
                --retries;
            }
        }
        return sock;
    }

    public int getClientListenerPort() {
        return this.srcPort;
    }

    public String getClientListenerURL() {
        return "http://" + ClientManager.getParam("clientBindIP") + ":" + this.srcPort;
    }

    public void close() {
        this.socketOpened = false;
        try {
            if (this.inconnection != null) {
                this.inconnection.close();
                this.inconnection = null;
            }
            if (this.sconnection != null) {
                this.sconnection.close();
                this.sconnection = null;
            }
        }
        catch (IOException e) {
            System.out.println("Unable to close the connection -> " + e);
        }
    }
}

