/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.common;

import com.sun.portal.netlet.client.common.BrowserType;
import com.sun.portal.netlet.client.common.ClientConfig;
import com.sun.portal.netlet.client.common.ClientUtil;
import com.sun.portal.netlet.client.common.NetletErrorDialog;
import com.sun.portal.netlet.client.common.PortWarning;
import com.sun.portal.netlet.client.common.RWGroupCrypt;
import com.sun.portal.netlet.client.common.ReauthDialog;
import com.sun.portal.netlet.client.common.ResourceProperties;
import com.sun.portal.netlet.client.common.SClientMgr;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;

class SClient
implements Runnable,
ActionListener {
    private Socket inconnection;
    private ServerSocket sconnection = null;
    private volatile boolean go = true;
    public boolean stopped = false;
    private int srcPortInRule;
    private int srcPort;
    private String serverPort;
    private String serverHost;
    private SClientMgr scm;
    private boolean trans;
    private int keyLength;
    private String cipherName;
    private Hashtable rwgroup;
    private Thread t = null;
    private String t_name;
    private Frame f = new Frame();
    private PortWarning pw;
    private ReauthDialog rad;
    private NetletErrorDialog ned;
    private int lastIEIndex;
    private volatile boolean start = false;
    private int connectionType = 0;

    public SClient(int srcp, String srvdest, String srvhost, String name, SClientMgr scm, boolean _trans, String ciphername, int keylength) {
        if (srcp == 30021) {
            this.connectionType = 1;
        } else if (srcp == 135) {
            this.connectionType = 2;
        }
        this.trans = _trans;
        this.srcPortInRule = srcp;
        this.srcPort = srcp;
        this.serverPort = new String(srvdest);
        this.serverHost = new String(srvhost);
        this.t_name = new String(name);
        this.scm = scm;
        this.cipherName = ciphername;
        this.keyLength = keylength;
        this.rwgroup = new Hashtable(20);
    }

    public void start() {
        this.stopped = false;
        BrowserType browser = BrowserType.getInstance();
        if (browser.getNetscapeBrowser() && browser.getJavaVMVersion() == 1) {
            try {
                BrowserType.SecurityCall sc = browser.enablePermission(0);
                sc.getMethod().invoke(null, sc.getArgs());
                sc = browser.enablePermission(1);
                sc.getMethod().invoke(null, sc.getArgs());
                sc = browser.enablePermission(3);
                sc.getMethod().invoke(null, sc.getArgs());
            }
            catch (Exception e) {
                System.out.println("SClient exception (start) (no privilege): " + e);
            }
        }
        if (this.sconnection == null) {
            this.sconnection = this.makeServerSocket();
        }
        this.go = true;
        if (this.t == null) {
            this.t = new Thread((Runnable)this, this.t_name);
            this.t.start();
        }
    }

    public void run() {
        BrowserType browser = BrowserType.getInstance();
        if (browser.getNetscapeBrowser() && browser.getJavaVMVersion() == 1) {
            try {
                BrowserType.SecurityCall sc = browser.enablePermission(0);
                sc.getMethod().invoke(null, sc.getArgs());
                sc = browser.enablePermission(1);
                sc.getMethod().invoke(null, sc.getArgs());
                sc = browser.enablePermission(3);
                sc.getMethod().invoke(null, sc.getArgs());
            }
            catch (Exception e) {
                System.out.println("SClient exception (run) (no privilege): " + e);
            }
        }
        this.pw = new PortWarning(this.f, this, this.srcPort);
        this.rad = new ReauthDialog(this.f, this, this.srcPort);
        this.ned = new NetletErrorDialog(this.f, this, null, null);
        while (this.go) {
            block23: {
                if (this.sconnection == null) {
                    this.go = false;
                    continue;
                }
                try {
                    this.inconnection = this.sconnection.accept();
                }
                catch (IOException e) {
                    try {
                        this.sconnection.close();
                        Thread.sleep(5L);
                        if (!this.go) {
                            break;
                        }
                    }
                    catch (IOException ee) {
                        System.out.println("SClient serversocket accept problem close error:");
                        ee.printStackTrace();
                    }
                    catch (InterruptedException ee) {
                    }
                    catch (NullPointerException ee) {
                        return;
                    }
                    if (!this.go) break block23;
                    this.sconnection = this.makeServerSocket();
                    continue;
                }
            }
            try {
                this.inconnection.setTcpNoDelay(true);
            }
            catch (SocketException e) {
                System.out.println("SClient accept socket error setting tcpNoDelay");
                e.printStackTrace();
                this.go = false;
            }
            if (this.inconnection == null) continue;
            if (this.trans) {
                this.closeServerSocket();
            }
            System.out.println("Netlet got connection on port: " + this.inconnection.getLocalPort() + " from port:" + this.inconnection.getPort());
            if (ClientConfig.doReauth()) {
                System.out.println("Netlet showing reauthentication dialog : " + this.inconnection.getLocalPort());
                this.rad.showWarning();
                this.rad.waitForAction();
                if (this.start) {
                    this.startConnection();
                }
            } else if (ClientConfig.doPortWarning() && !this.pw.getDontShow()) {
                if (BrowserType.getInstance().getIEBrowser()) {
                    this.startConnection();
                }
                System.out.println("Netlet showing port warning dialog:" + this.inconnection.getLocalPort());
                this.pw.showWarning();
                this.pw.waitForAction();
                if (this.start) {
                    this.startConnection();
                }
            } else {
                this.startConnection();
            }
            if (!this.trans) continue;
            return;
        }
        this.stop();
    }

    public boolean isTrans() {
        return this.trans;
    }

    public void startConnection() {
        int empty;
        this.start = false;
        this.lastIEIndex = empty = this.getRWindex();
        this.rwgroup.remove("" + empty);
        RWGroupCrypt rwg = new RWGroupCrypt(this.inconnection, this.connectionType, this.srcPort, this.serverPort, this.serverHost, this.scm, this, this.cipherName, this.keyLength);
        this.rwgroup.put("" + empty, rwg);
    }

    public synchronized void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.t != null) {
            this.go = false;
        }
        this.stopRWGroup();
        this.closeConnection();
        this.closeServerSocket();
        this.cleanup();
    }

    public void handleReauthOKButtonRequest() {
        String result = "FAILED";
        String password = this.rad.getPassword();
        if (password == null || password.trim().length() == 0) {
            result = "FAILED";
        } else {
            InputStream inStream = ClientUtil.sendByPost("doReauth", "&password=" + URLEncoder.encode(password));
            if (inStream != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
                try {
                    result = br.readLine();
                    System.out.println("SClient: Reauth " + result);
                    br.close();
                }
                catch (IOException ioe) {
                    result = "FAILED";
                }
            }
        }
        if (result != null && result.equals("SUCCESS")) {
            this.start = true;
            this.rad.notifyAction();
            this.rad.setVisible(false);
        } else {
            this.rad.notifyAction();
            this.rad.setVisible(false);
            this.ned.setErrorMessage(ResourceProperties.getString("reauth.error"));
            this.ned.setVisible(true);
            this.closeConnection();
        }
    }

    public void handleReauthCancelButtonRequest() {
        this.closeConnection();
        this.rad.notifyAction();
        this.rad.setVisible(false);
    }

    public void handlePortWarnOKButtonRequest() {
        if (!BrowserType.getInstance().getIEBrowser()) {
            this.start = true;
        }
        this.pw.notifyAction();
        this.pw.setVisible(false);
    }

    public void handlePortWarnCancelButtonRequest() {
        RWGroupCrypt rwg;
        if (BrowserType.getInstance().getIEBrowser() && this.lastIEIndex != -1 && (rwg = (RWGroupCrypt)this.rwgroup.get("" + this.lastIEIndex)) != null) {
            rwg.stopAll();
            this.rwgroup.remove("" + this.lastIEIndex);
        }
        this.closeConnection();
        this.pw.setDontShow(false);
        this.pw.notifyAction();
        this.pw.setVisible(false);
    }

    public void closeConnection() {
        try {
            if (this.inconnection != null) {
                this.inconnection.close();
                this.inconnection = null;
            }
        }
        catch (IOException e) {
            System.out.println("Unable to close the connection -> " + e);
        }
    }

    public void closeServerSocket() {
        try {
            if (this.sconnection != null) {
                this.sconnection.close();
                this.sconnection = null;
            }
        }
        catch (IOException e) {
            System.out.println("Unable to close the server socket -> " + e);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if ("OK".equals(evt.getActionCommand())) {
            if (obj == this.rad.ok) {
                this.handleReauthOKButtonRequest();
            } else if (obj == this.pw.ok) {
                this.handlePortWarnOKButtonRequest();
            } else if (obj == this.ned.okButton) {
                this.ned.setVisible(false);
            }
        } else if ("Cancel".equals(evt.getActionCommand())) {
            if (obj == this.rad.cancel) {
                this.handleReauthCancelButtonRequest();
            } else if (obj == this.pw.cancel) {
                this.handlePortWarnCancelButtonRequest();
            }
        }
    }

    public ServerSocket makeServerSocket() {
        ServerSocket sock = null;
        boolean go = true;
        int retries = 5;
        while (go) {
            try {
                InetAddress bindAddr = null;
                bindAddr = InetAddress.getByName(ClientConfig.getClientBindIP());
                sock = new ServerSocket(this.srcPort, 10, bindAddr);
                this.srcPort = sock.getLocalPort();
                go = false;
            }
            catch (UnknownHostException uhe) {
                System.out.println("Unable to make server socket at port " + this.srcPort + " and host " + ClientConfig.getClientBindIP() + " " + uhe);
                sock = null;
                this.srcPort = 0;
                go = false;
            }
            catch (IOException ioe) {
                System.out.println("Unable to make server socket at port " + this.srcPort + " and host " + ClientConfig.getClientBindIP() + " " + ioe);
                sock = null;
                this.srcPort = 0;
                go = retries > 0;
                --retries;
            }
        }
        return sock;
    }

    public int getRWindex() {
        int i = 0;
        boolean found = false;
        Enumeration e = this.rwgroup.elements();
        while (!found && e.hasMoreElements()) {
            RWGroupCrypt rwg = (RWGroupCrypt)e.nextElement();
            if (rwg == null) {
                found = true;
                continue;
            }
            if (rwg.done) {
                found = true;
                continue;
            }
            ++i;
        }
        return i;
    }

    public void stopRWGroup() {
        Enumeration e = this.rwgroup.elements();
        while (e.hasMoreElements()) {
            RWGroupCrypt rwg = (RWGroupCrypt)e.nextElement();
            if (rwg == null || rwg.done) continue;
            rwg.stopAll();
        }
        this.rwgroup.clear();
    }

    private void cleanup() {
        this.serverHost = null;
        if (this.pw != null) {
            this.pw.dispose();
            this.pw = null;
        }
        if (this.rad != null) {
            this.rad.dispose();
            this.rad = null;
        }
        this.t_name = null;
    }

    public String getName() {
        if (this.t != null) {
            return this.t.getName();
        }
        return null;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public int getSrcPortInRule() {
        return this.srcPortInRule;
    }
}

