/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.common;

import com.sun.portal.kssl.SSLStreamConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public class KSSLSocket
extends Socket {
    private SSLStreamConnection sslconn = null;

    public KSSLSocket(String destHost, int destPort, String[] cipherSuites) throws UnknownHostException, IOException {
        super(destHost, destPort);
        String[] ksslCiphers;
        this.sslconn = cipherSuites != null ? ((ksslCiphers = this.getKSSLCipherSuites(cipherSuites)) != null ? new SSLStreamConnection(destHost, destPort, super.getInputStream(), super.getOutputStream(), ksslCiphers) : new SSLStreamConnection(destHost, destPort, super.getInputStream(), super.getOutputStream())) : new SSLStreamConnection(destHost, destPort, super.getInputStream(), super.getOutputStream());
        try {
            this.setTcpNoDelay(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public KSSLSocket(Socket tunnelSocket, String destHost, int destPort, String[] cipherSuites) throws UnknownHostException, IOException {
        String[] ksslCiphers;
        this.sslconn = cipherSuites != null ? ((ksslCiphers = this.getKSSLCipherSuites(cipherSuites)) != null ? new SSLStreamConnection(destHost, destPort, tunnelSocket.getInputStream(), tunnelSocket.getOutputStream(), ksslCiphers) : new SSLStreamConnection(destHost, destPort, tunnelSocket.getInputStream(), tunnelSocket.getOutputStream())) : new SSLStreamConnection(destHost, destPort, tunnelSocket.getInputStream(), tunnelSocket.getOutputStream());
    }

    public InputStream getInputStream() throws IOException {
        return this.sslconn.openInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.sslconn.openOutputStream();
    }

    public void close() throws IOException {
        this.sslconn.close();
    }

    private String[] getKSSLCipherSuites(String[] cipherSuites) {
        Vector<String> ksslCiphers = new Vector<String>();
        for (int i = 0; i < cipherSuites.length; ++i) {
            if (cipherSuites[i] == null || cipherSuites[i] == "null" || !cipherSuites[i].startsWith("KSSL_")) continue;
            ksslCiphers.addElement(new String(cipherSuites[i]));
        }
        if (ksslCiphers.size() == 0) {
            return null;
        }
        String[] arrayofKSSLCiphers = new String[ksslCiphers.size()];
        for (int j = 0; j < ksslCiphers.size(); ++j) {
            arrayofKSSLCiphers[j] = ksslCiphers.elementAt(j).toString();
        }
        return arrayofKSSLCiphers;
    }
}

