/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.common;

import com.sun.portal.netlet.client.common.ProxyInfo;
import java.util.Enumeration;
import java.util.Hashtable;

public class ClientConfig {
    private static Hashtable parameters = new Hashtable();
    private static String destProtocol;
    private static String destHost;
    private static int destPort;
    private static boolean doPortWarning;
    private static boolean showPortWarnCheckbox;
    private static boolean doReauth;
    private static boolean JSSEEnabled;
    private static boolean PDCEnabled;
    private static boolean proxyletMode;
    private static boolean proxyMode;
    private static String proxyHost;
    private static int proxyPort;
    private static String proxyAuthUsername;
    private static String proxyAuthPassword;
    public static final int DIRECT = 0;
    public static final int MANUAL = 1;
    public static final int AUTO = 2;
    public static final int BROWSER = 3;
    public static final int NORMAL = 0;
    public static final int FTP = 1;
    public static final int EXCHANGE = 2;

    public static void addParams(Hashtable params) {
        Enumeration enumeration = params.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            parameters.put(key, params.get(key));
        }
    }

    public static void addParam(String key, String value) {
        if (key != null && value != null) {
            parameters.put(key, value);
        }
    }

    public static void init() {
        ClientConfig.initParams();
    }

    private static void initParams() {
        ClientConfig.getGWNameAndPort();
        String tmp = null;
        tmp = ClientConfig.getParam("doPortWarning");
        if (tmp != null && tmp.equalsIgnoreCase("true")) {
            doPortWarning = true;
        }
        if ((tmp = ClientConfig.getParam("showPortWarnCheckbox")) != null && tmp.equalsIgnoreCase("true")) {
            showPortWarnCheckbox = true;
        }
        if ((tmp = ClientConfig.getParam("doReauth")) != null && tmp.equalsIgnoreCase("true")) {
            doReauth = true;
        }
        if ((tmp = ClientConfig.getParam("isPDCEnabled")) != null && tmp.equalsIgnoreCase("true")) {
            PDCEnabled = true;
        }
        if ((tmp = ClientConfig.getParam("isJSSEEnabled")) != null && tmp.equalsIgnoreCase("true")) {
            JSSEEnabled = true;
        }
        if ((tmp = ClientConfig.getParam("proxyletMode")) != null && tmp.equalsIgnoreCase("true")) {
            proxyletMode = true;
        }
    }

    private static void getGWNameAndPort() {
        String gwURL = ClientConfig.getGWURL();
        if (gwURL != null || !gwURL.equals("")) {
            String tmp = null;
            destProtocol = gwURL.substring(0, gwURL.indexOf(58));
            tmp = gwURL.substring(destProtocol.length() + 3, gwURL.length());
            int gwPortIndex = (tmp = tmp.substring(0, tmp.indexOf(47))).indexOf(58);
            if (gwPortIndex == -1) {
                destHost = tmp;
                if (destProtocol.equals("http")) {
                    destPort = 80;
                } else if (destProtocol.equals("https")) {
                    destPort = 443;
                }
            } else {
                destHost = tmp.substring(0, gwPortIndex);
                try {
                    destPort = Integer.parseInt(tmp.substring(gwPortIndex + 1, tmp.length()));
                }
                catch (NumberFormatException n) {
                    System.out.println("Netlet unable to parse gwination port");
                }
            }
        }
        System.out.println("gateway protocol : " + destProtocol);
        System.out.println("gateway host : " + destHost);
        System.out.println("gateway port : " + destPort);
    }

    public static String getParam(String name) {
        return (String)parameters.get(name);
    }

    public static void loadProxyDetails(ProxyInfo pi) {
        proxyHost = pi.getProxySSL();
        proxyPort = pi.getProxySSLPort();
        proxyMode = pi.getProxyMode();
        System.out.println("Client Config proxyHost " + proxyHost);
        System.out.println("Client Config proxyPort " + proxyPort);
        System.out.println("Client Config proxyMode " + proxyMode);
    }

    public static String getConfigURL() {
        return ClientConfig.getParam("configURL");
    }

    public static String getGWURL() {
        return ClientConfig.getParam("gwURL");
    }

    public static String getTargetURL() {
        String targetURL = ClientConfig.getParam("targetURL");
        if (targetURL == null || targetURL.length() <= 0) {
            String confURL;
            targetURL = confURL = ClientConfig.getConfigURL();
            if (proxyletMode && confURL.startsWith("/")) {
                System.out.println("ClientConfig : proxylet running");
                String codebaseURL = ClientConfig.getParam("codebaseURL");
                if (codebaseURL != null && codebaseURL.length() > 0) {
                    int hostIndex = codebaseURL.indexOf("/");
                    int portIndex = codebaseURL.indexOf("/", hostIndex + 2);
                    targetURL = ClientConfig.getGWURL() + codebaseURL.substring(0, portIndex) + confURL;
                } else {
                    System.err.println("Enable to get codebase url");
                }
            } else {
                targetURL = confURL;
            }
            ClientConfig.addParam("targetURL", targetURL);
        }
        return targetURL;
    }

    public static String getServerURL() {
        int doubleSlashIndex = ClientConfig.getConfigURL().indexOf("//");
        String serverURL = ClientConfig.getConfigURL().substring(0, ClientConfig.getConfigURL().indexOf("/", doubleSlashIndex + 2));
        System.out.println("serverURL " + serverURL);
        return serverURL;
    }

    public static String getDestProtocol() {
        return destProtocol;
    }

    public static String getDestHost() {
        return destHost;
    }

    public static int getDestPort() {
        return destPort;
    }

    public static String getCookieName() {
        return ClientConfig.getParam("cookiename");
    }

    public static String getClientBindIP() {
        return ClientConfig.getParam("clientBindIP");
    }

    public static String getSessionID() {
        return ClientConfig.getParam("sessionId");
    }

    public static void setSessionID(String id) {
        ClientConfig.addParam("sessionId", new String(id));
    }

    public static int getNumOfRules() {
        return Integer.parseInt(ClientConfig.getParam("numParms"));
    }

    public static boolean doPortWarning() {
        return doPortWarning;
    }

    public static boolean showPortWarnCheckbox() {
        return showPortWarnCheckbox;
    }

    public static boolean doReauth() {
        return doReauth;
    }

    public static boolean isJSSEEnabled() {
        return JSSEEnabled;
    }

    public static boolean isPDCEnabled() {
        return PDCEnabled;
    }

    public static boolean isProxyletMode() {
        return proxyletMode;
    }

    public static boolean isProxyMode() {
        return proxyMode;
    }

    public static String getProxyHost() {
        return proxyHost;
    }

    public static int getProxyPort() {
        return proxyPort;
    }

    public static void setProxyAuthUsername(String name) {
        proxyAuthUsername = name;
    }

    public static void setProxyAuthPassword(String name) {
        proxyAuthPassword = name;
    }

    public static String getProxyAuthUsername() {
        return proxyAuthUsername;
    }

    public static String getProxyAuthPassword() {
        return proxyAuthPassword;
    }

    public static boolean getProxyAuth() {
        return proxyAuthUsername != null && proxyAuthPassword != null;
    }

    static {
        doPortWarning = false;
        showPortWarnCheckbox = false;
        doReauth = false;
        JSSEEnabled = false;
        PDCEnabled = false;
        proxyletMode = false;
    }
}

