/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.cli;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.sun.portal.common.clip.CLIPParser;
import com.sun.portal.portlet.cli.PortletDeployerCommand;
import com.sun.portal.portlet.cli.PortletDeployerException;
import com.sun.portal.portlet.cli.PortletDeployerLocalizer;
import java.util.Locale;

class PortletDeployerMain {
    public static final String COMMANDNAME = "pdeploy";
    public static final String COMMANDVERSION = "1.0";
    public static final String LOG_FILENAME = "pdeploy.debug";
    private static Debug debug = null;

    PortletDeployerMain(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-l") && !args[i].equals("--locale") || i >= args.length - 1) continue;
            Locale locale = PortletDeployerLocalizer.getLocale(args[i + 1]);
            PortletDeployerException.setLocale(locale);
            PortletDeployerLocalizer.setLocale(locale);
        }
        debug = Debug.getInstance((String)LOG_FILENAME);
        if (debug == null) {
            Object[] tokens = new Object[]{LOG_FILENAME};
            PortletDeployerLocalizer.error("errorLogInitFailed", tokens);
        } else {
            debug.setDebug(1);
        }
    }

    public static void main(String[] args) {
        SystemProperties.initializeProperties((String)"com.sun.identity.security.amadmin", (String)"true");
        PortletDeployerMain pd = new PortletDeployerMain(args);
        CLIPParser clipp = null;
        try {
            clipp = PortletDeployerCommand.getCLIPParser();
            PortletDeployerCommand cmd = new PortletDeployerCommand(clipp, args);
            cmd.runCommand();
            System.exit(0);
        }
        catch (PortletDeployerException pdex) {
            String wrappedMsg = pdex.getWrappedMessage();
            if (wrappedMsg != null && wrappedMsg.length() > 0) {
                Object[] tokens = new Object[]{pdex.getLocalizedMessage(), wrappedMsg};
                PortletDeployerLocalizer.error("msgWrappedError", tokens);
            } else {
                Object[] tokens = new Object[]{pdex.getLocalizedMessage()};
                PortletDeployerLocalizer.error("msgError", tokens);
            }
            debug.setDebug(1);
            debug.error("Exception: ", (Throwable)pdex);
            System.exit(1);
        }
        catch (Exception ex) {
            Object[] tokens = new Object[]{ex.getLocalizedMessage()};
            PortletDeployerLocalizer.error("msgError", tokens);
            debug.setDebug(1);
            debug.error("Exception: ", (Throwable)ex);
            System.exit(1);
        }
    }
}

