/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.tools.MultipartRequest;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.FormHandler;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;

public class FileUploadFormHandler
extends FormHandler {
    public static final String CONFIG_UPLOADPATH = "fileuploadformhandler.uploadpath";
    private File _uploadFile;

    public boolean init(String actionName, PropertyReader propertyReader, XSLXMLLogHandler logHandler) {
        Properties configProperties = propertyReader.getProperties();
        boolean init = super.init(actionName, propertyReader, logHandler);
        if (!init) {
            return false;
        }
        String uploadPath = configProperties.getProperty(CONFIG_UPLOADPATH, "/tmp");
        this._uploadFile = new File(uploadPath);
        if (!this._uploadFile.isDirectory()) {
            this._logHandler.error("FileUploadFormHandler: wrong path: " + uploadPath);
            return false;
        }
        return true;
    }

    public boolean process(HttpServletRequest request, Element errorRootElt) {
        MultipartRequest multiRequest = (MultipartRequest)request;
        InputStream in = multiRequest.getFileParameter("file");
        if (in == null) {
            this._logHandler.error("FileUploadFormHandler: null file");
            return false;
        }
        String filename = multiRequest.getParameter("filename");
        if (filename == null || filename.length() == 0) {
            this._logHandler.error("FileUploadFormHandler: null filename");
            return false;
        }
        File file = new File(this._uploadFile, filename);
        try {
            file.createNewFile();
        }
        catch (IOException ioe) {
            this._logHandler.error("FileUploadFormHandler: failed to create " + file.toString());
            return false;
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            int read = 0;
            while (read != -1) {
                byte[] some = new byte[1];
                read = in.read(some);
                if (read == -1) continue;
                out.write(some);
            }
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            this._logHandler.error("FileUploadFormHandler: failed to write " + file.toString() + " : " + ex.getMessage());
            return false;
        }
        return true;
    }
}

