/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.util.Enumeration;
import java.util.Vector;

public abstract class CacheableObject {
    public static final int LEAF = 1;
    public static final int COMPOSITE = 2;
    public static final int LINK = 3;
    private long _lastLoaded = 0L;
    private CacheableObject _parent = null;
    private Object _object = null;
    private Vector _dependenceVector = new Vector();
    protected XSLXMLLogHandler _errorHandler = null;

    public CacheableObject(XSLXMLLogHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public void setObject(Object object) {
        this._object = object;
    }

    public Object getObject() {
        if (this._parent != null) {
            return this._parent.getObject();
        }
        return this._object;
    }

    public long getLastLoaded() {
        return this._lastLoaded;
    }

    public void setLastLoaded() {
        this._lastLoaded = System.currentTimeMillis();
    }

    public void setParent(CacheableObject parent) {
        this._parent = parent;
        this._lastLoaded = parent.getLastLoaded();
        this.dependsOn(parent);
    }

    public void dependsOn(CacheableObject dependence) {
        this._dependenceVector.add(dependence);
        long dependenceLastLoaded = dependence.getLastLoaded();
        if (dependenceLastLoaded > this._lastLoaded) {
            this._lastLoaded = dependenceLastLoaded;
        }
    }

    public boolean isOutdated() throws XMLProcessingException {
        boolean modified = this.modifiedSince(this._lastLoaded);
        if (!modified) {
            return false;
        }
        return !this._dependenceVector.isEmpty();
    }

    public boolean modifiedSince(long lastLoaded) throws XMLProcessingException {
        boolean modified = false;
        if (this._dependenceVector.isEmpty()) {
            boolean reloaded = this.checkReloadLeaf();
            if (reloaded) {
                this.setLastLoaded();
            }
            if (lastLoaded < this._lastLoaded) {
                modified = true;
            }
        } else {
            Enumeration e = this._dependenceVector.elements();
            while (e.hasMoreElements()) {
                CacheableObject dependence = (CacheableObject)e.nextElement();
                if (!dependence.modifiedSince(lastLoaded)) continue;
                modified = true;
            }
        }
        return modified;
    }

    public int getType() {
        if (this._parent != null) {
            return 3;
        }
        if (this._dependenceVector.isEmpty()) {
            return 1;
        }
        return 2;
    }

    public CacheableObject getParent() {
        return this._parent;
    }

    protected abstract boolean checkReloadLeaf() throws XMLProcessingException;
}

