/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.auth.UserSessionFactory;
import com.iplanet.xslui.auth.XMLUserSession;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLUserSessionFactory
implements UserSessionFactory {
    private Document _dbDoc;

    public boolean init(File filePath) {
        try {
            XMLDOMBuilder builder = new XMLDOMBuilder(Logging.getLogHandler());
            this._dbDoc = builder.parse(new File(filePath, "usersdb.xml"));
        }
        catch (XMLProcessingException e) {
            Logging.error(1, "init: couldn't load usersdb.xml: " + e.getMessage());
            return false;
        }
        return true;
    }

    public UserSession newUserSession(String userID, String userDomain) {
        String entryID = userID + "@" + userDomain;
        String xpath = "*/user[@entryID='" + entryID + "']";
        Node userNode = null;
        Logging.trace(1, "XMLUserSession: opening DB for user: " + entryID);
        try {
            userNode = XPathTools.getFirstNodeByXPath((Node)this._dbDoc, (String)xpath);
        }
        catch (XSLProcessingException e) {
            Logging.error(1, "newUser: couldn't get parameter: " + e.getMessage());
            return null;
        }
        XMLUserSession user = null;
        try {
            user = new XMLUserSession(userNode);
        }
        catch (XMLProcessingException xe) {
            Logging.error(1, "newUser: couldn't get create UserSession: " + xe.getMessage());
            return null;
        }
        return user;
    }

    public UserSession newUserSession(String userID, String udn, String userDomain) {
        return this.newUserSession(userID, userDomain);
    }
}

