/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.util.HashMap;
import org.w3c.dom.Node;

public class XMLUserSession
implements UserSession {
    private String _user = null;
    private String _domain = null;
    private String _lang = null;
    private String _dn = null;
    private HashMap _cachedParams;
    private Node _userNode;

    public XMLUserSession(Node userNode) throws XMLProcessingException {
        if (userNode == null) {
            throw new XMLProcessingException("null userNode");
        }
        this._userNode = userNode;
        this._cachedParams = new HashMap(10);
        try {
            this._user = XPathTools.getValueByXPath((Node)this._userNode, (String)"uid");
            this._domain = XPathTools.getValueByXPath((Node)this._userNode, (String)"domain");
            this._lang = XPathTools.getValueByXPath((Node)this._userNode, (String)"preferredLanguage");
        }
        catch (XSLProcessingException e) {
            Logging.error(1, "init: couldn't get parameter: " + e.getMessage());
            throw new XMLProcessingException("couldn't get param: " + e.getMessage());
        }
        if (this._lang == null || this._lang.length() <= 0) {
            this._lang = "en";
        }
    }

    public String getUserId() {
        return this._user;
    }

    public String getDomain() {
        return this._domain;
    }

    public String getPreferredLanguage() {
        return this._lang;
    }

    public String getDN() {
        return this._dn;
    }

    public String getUserAttrib(String attribName) {
        if (attribName == null) {
            return null;
        }
        String value = (String)this._cachedParams.get(attribName);
        if (value == null) {
            try {
                value = XPathTools.getValueByXPath((Node)this._userNode, (String)attribName);
            }
            catch (XSLProcessingException e) {
                Logging.error(1, "getUserAttrib: no such attribute: " + attribName);
                return null;
            }
            if (value == null) {
                return null;
            }
            this._cachedParams.put(attribName, value);
        }
        return value;
    }
}

