/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.MessagingSSO;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.XSLServlet;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class MessagingVerifySSOServlet
extends XSLServlet {
    public static final String CONFIG_FILENAME = "xslauth.properties";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    private boolean _enabled = true;
    private MessagingSSO _messagingSSO = null;

    public void init(ServletConfig config) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(config);
        PropertyReader propertyReader = super.getPropertyReader();
        this._messagingSSO = new MessagingSSO(propertyReader);
        this._enabled = this._messagingSSO.isEnabled();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream output = response.getOutputStream();
        if (!this._enabled) {
            this._messagingSSO.sendError(output, "SSO disabled");
            return;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            this._messagingSSO.sendError(output, "No cookie in request");
            return;
        }
        String ipFromRequest = request.getParameter("client");
        if (this._messagingSSO.hasSessionCookie(cookies)) {
            HttpSession session = request.getSession(true);
            String ipFromSession = (String)session.getAttribute("com.iplanet.xslui.ui.clientIP");
            if (ipFromRequest == null || ipFromSession == null || !ipFromSession.trim().equalsIgnoreCase(ipFromRequest)) {
                this._messagingSSO.sendError(output, "IP addresses dont match");
                return;
            }
            UserSession userSession = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
            if (userSession == null) {
                this._messagingSSO.sendError(output, "No valid cookie");
                return;
            }
            String fquid = userSession.getUserId() + "@" + userSession.getDomain();
            this._messagingSSO.sendSuccess(output, fquid, "plaintext");
            return;
        }
        Vector userCred = this._messagingSSO.verifySSO(cookies, ipFromRequest, false);
        if (userCred == null) {
            this._messagingSSO.sendError(output, "Remote Server sent an error");
            return;
        }
        this._messagingSSO.relaySuccess(output, userCred);
    }
}

