/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.MessagingSSO;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.auth.XSLAuthFilter;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class MessagingSSOAuthFilter
extends XSLAuthFilter {
    public static final String CONFIG_FILENAME = "xslauth.properties";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    private String _defaultDomain = null;
    private boolean _enabled = true;
    private MessagingSSO _messagingSSO = null;

    public void init(FilterConfig config) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(config);
        PropertyReader propertyReader = super.getPropertyReader();
        this._defaultDomain = propertyReader.getStringProperty(CONFIG_DEFAULTDOMAIN, "iplanet.com");
        this._messagingSSO = new MessagingSSO(propertyReader);
        this._enabled = this._messagingSSO.isEnabled();
    }

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (!this._enabled) {
            chain.doFilter(req, response);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpSession session = request.getSession(true);
        UserSession userSession = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
        if (userSession != null) {
            chain.doFilter(req, response);
            return;
        }
        Cookie cookie = this._messagingSSO.getSSOCookie(session);
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.addCookie(cookie);
        String clientIP = req.getRemoteAddr();
        session.setAttribute("com.iplanet.xslui.ui.clientIP", (Object)clientIP);
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            chain.doFilter(req, response);
            return;
        }
        Vector userCred = this._messagingSSO.verifySSO(cookies, clientIP, true);
        if (userCred == null) {
            chain.doFilter(req, response);
            return;
        }
        String fquidStr = (String)userCred.elementAt(0);
        String typeStr = (String)userCred.elementAt(1);
        int sep = fquidStr.indexOf("=");
        if (sep <= 0 || sep == fquidStr.length() - 1) {
            chain.doFilter(req, response);
            return;
        }
        String fquid = fquidStr.substring(sep + 1);
        if ((sep = fquid.lastIndexOf("@")) <= 0 || sep == fquid.length() - 1) {
            chain.doFilter(req, response);
            return;
        }
        String uid = fquid.substring(0, sep);
        String domain = fquid.substring(sep + 1);
        Logging.trace(64, "MessagingSSOAuth: login from " + uid);
        session.setAttribute("uid", (Object)uid);
        session.setAttribute("domainname", (Object)domain);
        Logging.trace(64, "MessagingSSOAuthFilter: user " + uid + "@" + domain + " authenticated");
        chain.doFilter(req, response);
    }

    public void destroy() {
    }
}

