/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.DefaultDomainMap;
import com.iplanet.xslui.auth.Domain;
import com.iplanet.xslui.auth.DomainMap;
import com.iplanet.xslui.auth.LDAPDomainMap;
import com.iplanet.xslui.auth.LDAPUserSession;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.auth.UserSessionFactory;
import com.iplanet.xslui.tools.LDAPConfigReader;
import com.iplanet.xslui.tools.LDAPPool;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.File;
import java.io.IOException;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class LDAPUserSessionFactory
implements UserSessionFactory {
    public static final String LDAPUSERSESSIONCONFIGPREFIX = "ldapusersession.";
    public static final String DEFAULTUGFILTER = "ldapusersession.defaultugfilter";
    public static final String UGATTR = "ldapusersession.ugattr";
    private String _defaultUGFilter = null;
    private String[] _ugAttr;
    private LDAPPool _ldapPool = null;
    private DomainMap _domainMap = null;

    public boolean init(File configPath) {
        PropertyReader propertyReader = null;
        try {
            propertyReader = new PropertyReader(configPath);
        }
        catch (IOException ioe) {
            Logging.error(64, "LDAPUserSessionFac: Cant read config at: " + configPath.getAbsolutePath() + ":" + ioe.getMessage());
            return false;
        }
        this._defaultUGFilter = propertyReader.getStringProperty(DEFAULTUGFILTER, "uid=%U");
        this._ugAttr = propertyReader.getStringArrayProperty(UGATTR, null);
        try {
            this._ldapPool = LDAPConfigReader.getLDAPPool((PropertyReader)propertyReader, (String)LDAPUSERSESSIONCONFIGPREFIX);
        }
        catch (LDAPException le) {
            Logging.error(64, "LDAPUserSessionFac: Cant get LDAP pool: " + configPath.getAbsolutePath() + ":" + le.getMessage());
            return false;
        }
        this._domainMap = new LDAPDomainMap();
        boolean initialized = this._domainMap.init(configPath);
        if (!initialized) {
            this._domainMap = new DefaultDomainMap();
            this._domainMap.init(configPath);
        }
        return true;
    }

    public UserSession newUserSession(String uid, String udn, String domain) {
        LDAPUserSession userSession = null;
        LDAPConnection ldapc = null;
        try {
            ldapc = this._ldapPool.getConnection();
        }
        catch (LDAPException le) {
            Logging.error(64, "couldnt get a connection from the pool:" + le.getMessage());
            return null;
        }
        if (ldapc == null) {
            Logging.error(64, "couldnt get a connection from the pool: time out");
            return null;
        }
        try {
            LDAPSearchResults results = ldapc.search(udn, 2, null, this._ugAttr, false);
            if (!results.hasMoreElements()) {
                this._ldapPool.close(ldapc);
                return null;
            }
            LDAPEntry entry = results.next();
            userSession = new LDAPUserSession(entry, domain);
        }
        catch (LDAPException e) {
            Logging.error(64, "LDAPUserSessionFac: search Returned: " + e.toString());
            this._ldapPool.close(ldapc);
            return null;
        }
        this._ldapPool.close(ldapc);
        return userSession;
    }

    public UserSession newUserSession(String userID, String domainName) {
        LDAPUserSession userSession = null;
        Domain domain = this._domainMap.getDomainObject(domainName);
        if (domain == null) {
            return null;
        }
        String basedn = domain.getNamespace();
        String filterPattern = domain.getAttribute("inetDomainSearchFilter");
        if (filterPattern == null) {
            filterPattern = this._defaultUGFilter;
        }
        String filter = this.buildFilter(filterPattern, userID, domainName);
        LDAPConnection ldapc = null;
        try {
            ldapc = this._ldapPool.getConnection();
        }
        catch (LDAPException le) {
            Logging.error(64, "couldnt get a connection from the pool:" + le.getMessage());
            return null;
        }
        if (ldapc == null) {
            Logging.error(64, "couldnt get a connection from the pool: time out");
            return null;
        }
        try {
            LDAPSearchResults results = ldapc.search(basedn, 2, filter, this._ugAttr, false);
            if (!results.hasMoreElements()) {
                Logging.error(64, "LDAPUserSessionFac: no result for: " + userID + " in domain " + domainName);
                this._ldapPool.close(ldapc);
                return null;
            }
            LDAPEntry entry = results.next();
            userSession = new LDAPUserSession(entry, domain);
        }
        catch (LDAPException e) {
            Logging.error(64, "LDAPUserSessionFac: search Returned: " + e.toString() + "for " + userID + " in domain " + domainName);
            this._ldapPool.close(ldapc);
            return null;
        }
        this._ldapPool.close(ldapc);
        return userSession;
    }

    private String buildFilter(String filterPattern, String userID, String domainName) {
        String filter = "";
        for (int i = 0; i < filterPattern.length(); ++i) {
            if (filterPattern.charAt(i) == '%' && i + 1 < filterPattern.length()) {
                switch (filterPattern.charAt(++i)) {
                    case 'U': {
                        filter = filter + this.ldapescape(userID);
                        break;
                    }
                    case 'V': {
                        filter = filter + this.ldapescape(domainName);
                        break;
                    }
                    case '%': {
                        filter = filter + '%';
                        break;
                    }
                }
                continue;
            }
            filter = filter + filterPattern.charAt(i);
        }
        return filter;
    }

    private String ldapescape(String value) {
        if (value == null) {
            return "";
        }
        String res = "";
        block6: for (int i = 0; i < value.length(); ++i) {
            switch (value.charAt(i)) {
                case '*': {
                    res = res + "\\2a";
                    continue block6;
                }
                case '(': {
                    res = res + "\\28";
                    continue block6;
                }
                case ')': {
                    res = res + "\\29";
                    continue block6;
                }
                case '\\': {
                    res = res + "\\5c";
                    continue block6;
                }
                default: {
                    res = res + value.charAt(i);
                }
            }
        }
        return res;
    }
}

