/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.transport;

import com.sun.portal.netfile.shared.NetFileException;
import com.sun.portal.netfile.transport.NetFileRequest;
import com.sun.portal.netfile.transport.NetFileResponse;
import com.sun.portal.netfile.transport.NetFileTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;

public class NetFileHTTPTransport
implements NetFileTransport {
    InputStream istream;
    OutputStream ostream;
    URLConnection urlConnection;
    ObjectInputStream oistream;
    ObjectOutputStream oostream;

    public NetFileResponse deserializeFromStream() throws NetFileException {
        NetFileResponse nfResp = null;
        try {
            nfResp = (NetFileResponse)this.oistream.readObject();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            throw new NetFileException(5, "NetFile Serialization Error - " + cnfe.getMessage());
        }
        return nfResp;
    }

    public void sendRequest(NetFileRequest nfReq) {
        URLConnection urlConn = this.urlConnection;
        try {
            this.serializeToStream(nfReq);
            this.oostream.close();
        }
        catch (Exception e) {
            System.out.println("**** Error occured in writing Request object to stream ****");
            e.printStackTrace();
        }
    }

    public NetFileResponse receiveResponse() {
        Object istream = null;
        NetFileResponse nfResp = null;
        try {
            if (this.oistream != null) {
                nfResp = this.deserializeFromStream();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nfResp;
    }

    public void closeConnection() throws IOException {
        if (this.oostream != null) {
            this.oostream.close();
        }
        if (this.oistream != null) {
            this.oistream.close();
        }
    }

    public void serializeToStream(NetFileRequest nfReq) throws NetFileException {
        try {
            this.oostream.writeObject(nfReq);
            this.oostream.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new NetFileException(8, "NetFile Serialization Error - Cannot create stream to write");
        }
    }

    public URLConnection createConnection(URL toSendTo) {
        URLConnection urlConn = null;
        if (toSendTo == null) {
            return null;
        }
        try {
            urlConn = toSendTo.openConnection();
            urlConn.setDoOutput(true);
            urlConn.setDoInput(true);
            urlConn.setAllowUserInteraction(false);
            urlConn.setUseCaches(false);
            urlConn.setRequestProperty("NetFileProtocolVersion", "HTTP_JAVA_SERIALIZE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return urlConn;
    }

    public void createInputStream() throws NetFileException {
        try {
            this.oistream = new ObjectInputStream(this.urlConnection.getInputStream());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            if (ioe instanceof StreamCorruptedException) {
                throw new NetFileException(952, "Could not create input stream.");
            }
            if (ioe instanceof IOException) {
                throw new NetFileException(15, "");
            }
            throw new NetFileException(6, "IOException. Could not create input stream.");
        }
    }

    public void connectToServer(URLConnection conn) throws IOException {
        URLConnection con = conn;
        if (con != null) {
            this.urlConnection = con;
        }
    }

    public void setTransportAttribute(String name, String value) throws NetFileException {
        try {
            String s = name + ":" + value;
            this.oostream.writeObject(s);
            this.oostream.flush();
        }
        catch (Exception ioe) {
            throw new NetFileException(8, "NetFile Serialization Error - Cannot create stream to write");
        }
    }

    public void createOutputStream() throws NetFileException {
        try {
            this.ostream = this.urlConnection.getOutputStream();
            this.oostream = new ObjectOutputStream(this.ostream);
            this.oostream.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            if (ioe instanceof StreamCorruptedException) {
                throw new NetFileException(952, "Could not create output stream.");
            }
            if (ioe instanceof ConnectException) {
                throw new NetFileException(15, "Could not create output stream.");
            }
            throw new NetFileException(6, "IOException. Could not create input stream.");
        }
    }
}

