/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.xslutil;

import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathTools {
    private static ArrayList _charToSearch = new ArrayList();

    public static Node getFirstNodeByXPath(Node node, String XPath) throws XSLProcessingException {
        ArrayList array = XPathTools.getNodesByXPath(node, XPath);
        if (array.size() > 0) {
            return (Node)array.get(0);
        }
        return null;
    }

    public static String getValueByXPath(Node node, String XPath) throws XSLProcessingException {
        Node curNode = null;
        if (XPath.startsWith("'")) {
            if (XPath.endsWith("'")) {
                return XPath.substring(1, XPath.length() - 1);
            }
            throw new XSLProcessingException("Missing simple quote in expression");
        }
        try {
            ArrayList nodelist = XPathTools.getNodesByXPath(node, XPath);
            if (nodelist.size() > 0 && (curNode = (Node)nodelist.get(0)) != null) {
                if (curNode.getNodeType() == 1) {
                    for (curNode = curNode.getFirstChild(); curNode != null && curNode.getNodeType() != 3; curNode = curNode.getNextSibling()) {
                    }
                }
                if (curNode != null) {
                    return curNode.getNodeValue();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new XSLProcessingException("Error retrieving value of node : " + e.getMessage());
        }
    }

    public static String[] getValuesByXPath(Node node, String XPath) throws XSLProcessingException {
        ArrayList matchingNodes = XPathTools.getNodesByXPath(node, XPath);
        String[] matchingValues = new String[matchingNodes.size()];
        for (int i = 0; i < matchingNodes.size(); ++i) {
            matchingValues[i] = XPathTools.getValueByXPath((Node)matchingNodes.get(i), ".");
        }
        return matchingValues;
    }

    public static ArrayList getNodesByXPath(Node node, String XPath) throws XSLProcessingException {
        ArrayList array = new ArrayList();
        XPathTools.getNodesByXPath(node, XPath, array);
        return array;
    }

    public static void getNodesByXPath(Node node, String XPath, ArrayList array) throws XSLProcessingException {
        block18: {
            Node curNode;
            block17: {
                curNode = null;
                Object foundNode = null;
                ArrayList PosAndChar = XPathTools.getFirstCharAndIndexOf(XPath, _charToSearch);
                if ((Integer)PosAndChar.get(0) == -1) break block17;
                switch (((String)PosAndChar.get(1)).charAt(0)) {
                    case '/': {
                        for (curNode = node.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
                            if (!XPathTools.stringMatch(curNode.getNodeName(), XPath.substring(0, (Integer)PosAndChar.get(0)), true)) continue;
                            XPathTools.getNodesByXPath(curNode, XPath.substring((Integer)PosAndChar.get(0) + 1), array);
                        }
                        break;
                    }
                    case '[': {
                        int sqBracketPos = (Integer)PosAndChar.get(0);
                        boolean continueAfterBracket = XPath.substring(0, XPath.indexOf("]") + 1).length() < XPath.length();
                        if (continueAfterBracket) {
                            ArrayList<Node> matchesArrayList = new ArrayList<Node>();
                            for (curNode = node.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
                                if (!XPathTools.stringMatch(curNode.getNodeName(), XPath.substring(0, sqBracketPos), true) || !XPathTools.bracketFormulaMatch(curNode, XPath.substring(sqBracketPos + 1, XPath.indexOf("]")))) continue;
                                matchesArrayList.add(curNode);
                            }
                            for (int i = 0; i < matchesArrayList.size(); ++i) {
                                XPathTools.getNodesByXPath((Node)matchesArrayList.get(i), XPath.substring(XPath.indexOf("]") + 2), array);
                            }
                        } else {
                            while (curNode != null) {
                                if (XPathTools.stringMatch(curNode.getNodeName(), XPath.substring(0, sqBracketPos), true) && XPathTools.bracketFormulaMatch(curNode, XPath.substring(sqBracketPos + 1, XPath.indexOf("]")))) {
                                    array.add(curNode);
                                }
                                curNode = curNode.getNextSibling();
                            }
                            break block0;
                        }
                    }
                }
                break block18;
            }
            if (XPath.equals(".")) {
                array.add(node);
            } else if (XPath.startsWith("@")) {
                if (node.getNodeType() == 1 && (curNode = ((Element)node).getAttributeNode(XPath.substring(1))) != null) {
                    array.add(curNode);
                }
            } else {
                for (curNode = node.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
                    if (!XPathTools.stringMatch(curNode.getNodeName(), XPath, true)) continue;
                    array.add(curNode);
                }
            }
        }
    }

    private static ArrayList getFirstCharAndIndexOf(String s, ArrayList _charToSearch) {
        ArrayList<Object> toReturn = new ArrayList<Object>(2);
        toReturn.add(0, new Integer(-1));
        toReturn.add(1, new String("#"));
        for (int i = 0; i < _charToSearch.size(); ++i) {
            int tmpPos = s.indexOf((String)_charToSearch.get(i));
            if (tmpPos < 0 || (Integer)toReturn.get(0) <= tmpPos && (Integer)toReturn.get(0) != -1) continue;
            toReturn.set(0, new Integer(tmpPos));
            toReturn.set(1, new String((String)_charToSearch.get(i)));
        }
        return toReturn;
    }

    public static boolean bracketFormulaMatch(Node node, String formula) throws XSLProcessingException {
        ArrayList<String> rightArrayList;
        int index = formula.indexOf("=");
        boolean rightMemberIsXPath = false;
        boolean toReturn = false;
        String leftStr = formula.substring(0, index).trim();
        String rightStr = formula.substring(index + 1).trim();
        ArrayList leftArrayList = XPathTools.getNodesByXPath(node, leftStr);
        if (rightStr.startsWith("'")) {
            if (!rightStr.endsWith("'")) {
                throw new XSLProcessingException("Missing simple quote in expression : " + formula);
            }
            rightArrayList = new ArrayList<String>();
            rightArrayList.add(rightStr.substring(1, rightStr.length() - 1));
        } else {
            rightArrayList = XPathTools.getNodesByXPath(node, rightStr);
            rightMemberIsXPath = true;
        }
        for (int i = 0; i < leftArrayList.size(); ++i) {
            for (int j = 0; j < rightArrayList.size(); ++j) {
                String s2;
                String s1 = XPathTools.getValueByXPath((Node)leftArrayList.get(i), ".");
                String string = s2 = rightMemberIsXPath ? XPathTools.getValueByXPath((Node)rightArrayList.get(j), ".") : (String)rightArrayList.get(j);
                if (s1 == null || s2 == null || !XPathTools.stringMatch(s1, s2, true)) continue;
                toReturn = true;
            }
        }
        return toReturn;
    }

    private static boolean stringMatch(String str, String Query, boolean ignoreCase) {
        String tmpStr = new String(Query);
        int offset = 0;
        if (Query.compareTo("*") == 0) {
            return true;
        }
        if (Query.indexOf("*") != -1) {
            int queryRightLen;
            int strLen = str.length();
            int queryLen = Query.length();
            if (Query.startsWith("*") && Query.endsWith("*")) {
                return ignoreCase ? str.toLowerCase().indexOf(Query.toLowerCase().substring(1, queryLen - 1)) != -1 : str.indexOf(Query.substring(1, queryLen - 1)) != -1;
            }
            if (Query.startsWith("*")) {
                offset = strLen - queryLen + 1 < 0 ? strLen : strLen - queryLen + 1;
                return XPathTools.stringMatch(str.substring(offset), Query.substring(1), ignoreCase);
            }
            if (Query.endsWith("*")) {
                offset = strLen - queryLen < 0 ? strLen : queryLen - 1;
                return XPathTools.stringMatch(str.substring(0, offset), Query.substring(0, Query.length() - 1), ignoreCase);
            }
            String queryLeft = Query.substring(0, Query.indexOf("*"));
            String queryRight = Query.substring(Query.indexOf("*") + 1);
            int queryLeftLen = queryLeft.length();
            if (strLen <= Math.min(queryLeftLen, queryRightLen = queryRight.length())) {
                return false;
            }
            String strLeft = str.substring(0, queryLeftLen);
            String strRight = str.substring(strLen - queryRightLen);
            int strLeftLen = strLeft.length();
            int strRightLen = strRight.length();
            boolean beforeStar = XPathTools.stringMatch(strLeft, queryLeft, ignoreCase);
            boolean afterStar = XPathTools.stringMatch(strRight, queryRight, ignoreCase);
            return beforeStar && afterStar;
        }
        return ignoreCase ? str.compareToIgnoreCase(Query) == 0 : str.compareTo(Query) == 0;
    }

    private static boolean stringMatch(StringBuffer str, StringBuffer Query, boolean ignoreCase) {
        return XPathTools.stringMatch(str.toString(), Query.toString(), ignoreCase);
    }

    public static void main(String[] args) {
        try {
            XMLDOMBuilder builder = new XMLDOMBuilder();
            Document document = builder.newDocument();
            if (args.length <= 1) {
                System.out.println("Syntaxe : SearchTest <file.xml> XPath");
                return;
            }
            document = builder.parse(new String(args[0]));
            System.out.println("XML file parsed");
            ArrayList nodelist = XPathTools.getNodesByXPath(document, args[1]);
            if (nodelist != null) {
                System.out.println(nodelist.size() + " matching results");
                System.out.println("Node name : " + ((Node)nodelist.get(0)).getNodeName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        _charToSearch.add("/");
        _charToSearch.add("[");
    }
}

