/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.tools;

import com.iplanet.xslui.tools.Comparer;
import java.util.ArrayList;

public final class QuickSort {
    Comparer comparer;
    ArrayList input;
    Object handle;

    QuickSort(ArrayList input, Comparer comparer, Object handle) {
        this.input = input;
        this.comparer = comparer;
        this.handle = handle;
    }

    public static void sort(ArrayList input) {
        new QuickSort(input, null, null).quickSort();
    }

    public static void sort(ArrayList input, Comparer comparer, Object handle) {
        new QuickSort(input, comparer, handle).quickSort();
    }

    void quickSort() {
        this.qs(0, this.input.size() - 1);
    }

    void qs(int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (lo >= hi) {
            return;
        }
        if (lo == hi - 1) {
            if (this.compare(this.a(lo), this.a(hi)) > 0) {
                this.swap(lo, hi);
            }
            return;
        }
        Object pivot = this.a((lo + hi) / 2);
        this.swap((lo + hi) / 2, hi);
        while (lo < hi) {
            while (this.compare(this.a(lo), pivot) <= 0 && lo < hi) {
                ++lo;
            }
            while (this.compare(pivot, this.a(hi)) <= 0 && lo < hi) {
                --hi;
            }
            if (lo >= hi) continue;
            this.swap(lo, hi);
        }
        this.input.set(hi0, this.a(hi));
        this.input.set(hi, pivot);
        this.qs(lo0, lo - 1);
        this.qs(hi + 1, hi0);
    }

    Object a(int pos) {
        return this.input.get(pos);
    }

    int compare(Object o1, Object o2) {
        if (this.comparer == null) {
            if (o1 instanceof Integer) {
                int i2;
                int i1 = (Integer)o1;
                if (i1 < (i2 = ((Integer)o2).intValue())) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                return 0;
            }
            return String.valueOf(o1).compareTo(String.valueOf(o2));
        }
        return this.comparer.compare(this.handle, o1, o2);
    }

    void swap(int low, int high) {
        Object temp = this.input.get(low);
        this.input.set(low, this.input.get(high));
        this.input.set(high, temp);
    }

    public static void main(String[] args) {
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            v.add(args[i]);
        }
        QuickSort.sort(v);
        System.out.println("Result:\n" + v);
    }
}

