/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertyReader {
    public static final String CONFIG_CLASS_SUFFIX = ".class";
    public static final String CONFIG_CONFIGPATH_SUFFIX = ".configpath";
    private File _configFile = null;
    private Properties _config = null;
    static /* synthetic */ Class class$java$io$File;

    public PropertyReader(File configFile) throws IOException {
        if (!configFile.isFile()) {
            throw new IOException("PropertyReader: config is not a file: " + configFile.toString());
        }
        this._configFile = configFile;
        FileInputStream configStream = null;
        try {
            configStream = new FileInputStream(configFile);
        }
        catch (Exception ex) {
            throw new IOException("PropertyReader: couldn't open configuration file" + configFile.toString() + " : " + ex.getMessage());
        }
        this._config = new Properties();
        try {
            this._config.load(configStream);
        }
        catch (IOException ioe) {
            throw new IOException("PropertyReader: cant load config " + configFile.toString() + " : " + ioe.getMessage());
        }
    }

    public PropertyReader(File configPath, String configFileName) throws IOException {
        this._configFile = new File(configPath, configFileName);
        if (!this._configFile.isFile()) {
            throw new IOException("PropertyReader: config is not a file: " + this._configFile.toString());
        }
        FileInputStream configStream = null;
        try {
            configStream = new FileInputStream(this._configFile);
        }
        catch (Exception ex) {
            throw new IOException("PropertyReader: couldn't open configuration file" + this._configFile.toString() + " : " + ex.getMessage());
        }
        this._config = new Properties();
        try {
            this._config.load(configStream);
        }
        catch (IOException ioe) {
            throw new IOException("PropertyReader: cant load config " + this._configFile.toString() + " : " + ioe.getMessage());
        }
    }

    public final String getStringProperty(String propertyName, String defaultValue) {
        String prop = this._config.getProperty(propertyName);
        if (prop == null) {
            return defaultValue;
        }
        return prop.trim();
    }

    public final String getLowerCaseStringProperty(String propertyName, String defaultValue) {
        String tmpString = this._config.getProperty(propertyName, defaultValue);
        if (tmpString != null) {
            return tmpString.toLowerCase();
        }
        return null;
    }

    public final String[] getStringArrayProperty(String propertyName, String defaultValue) {
        String stringProp = this.getStringProperty(propertyName, defaultValue);
        if (stringProp == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(stringProp, ",");
        int nb = st.countTokens();
        if (nb <= 0) {
            return null;
        }
        String[] stringArray = new String[nb];
        int i = 0;
        while (st.hasMoreTokens()) {
            stringArray[i++] = st.nextToken();
        }
        return stringArray;
    }

    public final int getIntProperty(String propertyName, int defaultValue) {
        int value;
        try {
            value = Integer.parseInt(this.getStringProperty(propertyName, ""));
        }
        catch (NumberFormatException nfe) {
            value = defaultValue;
        }
        return value;
    }

    public final boolean getBooleanProperty(String propertyName, String defaultValue) {
        return Boolean.valueOf(this.getStringProperty(propertyName, defaultValue));
    }

    public final File getFileProperty(String propertyName, String defaultValue) {
        String pathString = this.getStringProperty(propertyName, defaultValue);
        if (pathString == null || pathString.length() <= 0) {
            return null;
        }
        File path = new File(pathString);
        if (path.isAbsolute()) {
            return path;
        }
        return new File(this.getConfigPath(), pathString);
    }

    public final Object getObjectProperty(String propertyPrefix, boolean needsInit) throws IOException, InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        String className = this.getStringProperty(propertyPrefix + CONFIG_CLASS_SUFFIX, null);
        if (className == null) {
            return null;
        }
        Object theOne = null;
        Method theMethod = null;
        try {
            Class<?> theClass = Class.forName(className);
            theOne = theClass.newInstance();
        }
        catch (Exception ex) {
            throw new IOException("getObjectProperty: couldn't load " + className + " : " + ex.getMessage());
        }
        if (!needsInit) {
            return theOne;
        }
        try {
            theMethod = theOne.getClass().getMethod("init", class$java$io$File == null ? (class$java$io$File = PropertyReader.class$("java.io.File")) : class$java$io$File);
        }
        catch (Exception ex) {
            // empty catch block
        }
        File configPath = this.getFileProperty(propertyPrefix + CONFIG_CONFIGPATH_SUFFIX, null);
        if (configPath != null && theMethod != null) {
            boolean initialized = false;
            initialized = (Boolean)theMethod.invoke(theOne, configPath);
            if (!initialized) {
                throw new IOException("getObject: couldn't init " + className);
            }
        }
        return theOne;
    }

    public final Enumeration getKeyProperty(String propertyPrefix, String propertySuffix) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        Enumeration<?> enumeration = this._config.propertyNames();
        while (enumeration.hasMoreElements()) {
            String pattern;
            int end;
            int begining;
            String parameter = (String)enumeration.nextElement();
            if (!parameter.startsWith(propertyPrefix) || !parameter.endsWith(propertySuffix) || (begining = parameter.indexOf(".")) == (end = parameter.lastIndexOf(".")) || (pattern = parameter.substring(begining + 1, end)) == null || pattern.length() <= 0) continue;
            table.put(pattern, pattern);
        }
        return table.keys();
    }

    public final Enumeration getKeyPropertyBySuffix(String propertySuffix) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        Enumeration<?> enumeration = this._config.propertyNames();
        while (enumeration.hasMoreElements()) {
            String pattern;
            int lastDotIndex;
            int firstDotIndex;
            String parameter = (String)enumeration.nextElement();
            if (!parameter.endsWith(propertySuffix) || (firstDotIndex = parameter.indexOf(".")) != (lastDotIndex = parameter.lastIndexOf(".")) || (pattern = parameter.substring(0, firstDotIndex)) == null || pattern.length() <= 0) continue;
            table.put(pattern, pattern);
        }
        return table.keys();
    }

    public final File getConfigFile() {
        return this._configFile;
    }

    public final File getConfigPath() {
        return this._configFile.getParentFile();
    }

    public final Properties getProperties() {
        return this._config;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

