/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.xml;

import com.sun.portal.rewriter.util.xml.Tag;

public class TagParser {
    public static Tag parse(String aTagText) {
        return TagParser.parse(aTagText, null);
    }

    public static Tag parse(String aTagText, Tag aTag) {
        if (aTagText == null) {
            aTagText = "";
        }
        Tag lTag = aTag == null ? new Tag() : aTag;
        String lTagText = aTagText.trim();
        if (lTagText.indexOf("=") == -1) {
            lTag.setName(lTagText);
            return lTag;
        }
        String mayBeTagName = lTagText;
        int spaceIndex = lTagText.indexOf(" ");
        if (spaceIndex != -1) {
            mayBeTagName = lTagText.substring(0, spaceIndex);
        }
        String attributes = lTagText.substring(mayBeTagName.length()).trim();
        if (mayBeTagName.indexOf("=") == -1 && attributes.length() > 0 && attributes.charAt(0) != '=') {
            lTag.setName(mayBeTagName);
        } else {
            lTag.setName("null");
            attributes = lTagText;
        }
        return TagParser.parseAttributes(attributes, lTag);
    }

    public static Tag parseAttributes(String aTagContent, Tag aTag) {
        String lTagContent = aTagContent;
        int lStmtLength = lTagContent.length();
        boolean inSQuote = false;
        boolean inDQuote = false;
        boolean inESQuote = false;
        boolean inEDQuote = false;
        boolean endOfString = false;
        boolean lookForString = false;
        int start = 0;
        int mStartLink = 0;
        int mEndLink = 0;
        int equalindex = -1;
        int holder = 0;
        String mAttributeName = "";
        String mAttributeValue = "";
        boolean isValueSet = false;
        for (int i = 0; i < lStmtLength; ++i) {
            char c = lTagContent.charAt(i);
            if (Character.isWhitespace(c) || endOfString) {
                if (!inSQuote && !inDQuote) {
                    lookForString = false;
                    endOfString = false;
                    if (Character.isWhitespace(c)) {
                        while (i + 1 < lStmtLength && Character.isWhitespace(lTagContent.charAt(i + 1))) {
                            ++i;
                        }
                        if (i + 1 >= lStmtLength) {
                            start = i + 1;
                        } else {
                            if (lTagContent.charAt(i + 1) == '=') continue;
                            start = i + 1;
                        }
                    } else {
                        start = i;
                    }
                    isValueSet = true;
                }
            } else if (c == '\\') {
                if (i + 1 < lStmtLength) {
                    char c2 = lTagContent.charAt(i + 1);
                    if (c2 == '\'') {
                        if (i == equalindex + 1 || inESQuote) {
                            boolean bl = inESQuote = !inESQuote;
                            if (inESQuote) {
                                mStartLink = i + 2;
                            } else {
                                mEndLink = i;
                                endOfString = true;
                            }
                            ++i;
                        }
                    } else if (c2 == '\"' && (i == equalindex + 1 || inEDQuote)) {
                        boolean bl = inEDQuote = !inEDQuote;
                        if (inEDQuote) {
                            mStartLink = i + 2;
                        } else {
                            mEndLink = i;
                            endOfString = true;
                        }
                        ++i;
                    }
                }
            } else if (c == '\'') {
                if ((i == equalindex + 1 || inSQuote) && !inDQuote) {
                    boolean bl = inSQuote = !inSQuote;
                    if (inSQuote) {
                        mStartLink = i + 1;
                    } else {
                        mEndLink = i;
                        endOfString = true;
                    }
                }
            } else if (c == '\"') {
                if ((i == equalindex + 1 || inDQuote) && !inSQuote) {
                    boolean bl = inDQuote = !inDQuote;
                    if (inDQuote) {
                        mStartLink = i + 1;
                    } else {
                        mEndLink = i;
                        endOfString = true;
                    }
                }
            } else if (!(c != '=' || lookForString || inDQuote || inSQuote)) {
                equalindex = i;
                lookForString = true;
                mStartLink = i + 1;
                holder = i;
                while (mStartLink < lStmtLength && Character.isWhitespace(lTagContent.charAt(mStartLink))) {
                    ++equalindex;
                    ++mStartLink;
                    ++holder;
                }
                mAttributeName = lTagContent.substring(start, i).trim();
                i = holder;
            }
            if (!isValueSet && i + 1 != lStmtLength) continue;
            isValueSet = false;
            if (mStartLink > mEndLink) {
                mEndLink = i;
                if (i + 1 == lStmtLength) {
                    ++mEndLink;
                }
            }
            mAttributeValue = aTagContent.substring(mStartLink, mEndLink);
            aTag.put(mAttributeName.trim(), mAttributeValue.trim());
            mEndLink = i;
        }
        return aTag;
    }

    public static void main(String[] args) {
        String[] lData = new String[]{"base href=\"10\" u"};
        for (int i = 0; i < 1; ++i) {
            Tag t = TagParser.parse(lData[i], null);
            System.out.println(t);
        }
    }
}

