/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.i18n;

import com.sun.portal.rewriter.util.ConfigManager;
import com.sun.portal.rewriter.util.collections.ListMap;
import java.net.URLConnection;
import java.util.Map;

public final class MIMEHelper {
    public static final String UNKNOWN_MIME = "content/unknown";
    private static final Map extensionMAP = new ListMap();

    public static void init(String aResourceLocation) {
        if (aResourceLocation != null) {
            extensionMAP.putAll(ConfigManager.readProps(aResourceLocation));
        }
    }

    private static String guessContentTypeFromURLString(String fname) {
        String ext = "";
        int i = fname.lastIndexOf(35);
        if (i != -1) {
            fname = fname.substring(0, i - 1);
        }
        i = fname.lastIndexOf(46);
        i = Math.max(i, fname.lastIndexOf(47));
        if ((i = Math.max(i, fname.lastIndexOf(63))) != -1 && fname.charAt(i) == '.' && ++i < fname.length()) {
            ext = fname.substring(i).toLowerCase();
        }
        return MIMEHelper.guessContentTypeFromFileName("." + ext);
    }

    public static String guessContentTypeFromFileName(String fname) {
        String result = URLConnection.getFileNameMap().getContentTypeFor(fname);
        String ext = "";
        int i = fname.lastIndexOf(46);
        if (i != -1) {
            ext = fname.substring(i + 1).trim().toLowerCase();
        }
        if (result != null && !ext.equals("xml")) {
            return result;
        }
        result = (String)extensionMAP.get(ext);
        if (result == null) {
            result = (String)extensionMAP.get("");
        }
        return result;
    }

    static {
        extensionMAP.put("", UNKNOWN_MIME);
    }
}

