/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.clip;

import com.sun.portal.rewriter.util.clip.CLIPParser;
import com.sun.portal.rewriter.util.clip.CLIPSpec;
import com.sun.portal.rewriter.util.i18n.LocaleHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class CLIPOption {
    static final CLIPOption[] EMTPY_CLIP_OPTION_ARRAY = new CLIPOption[0];
    private String longName;
    private String shortName;
    private boolean mandatory;
    private int type;
    private String[] defaultValues = null;
    private final String helpMessageID;

    public CLIPOption(String aLongName, String aShortName, int aType, String aDefaultValues, String aHelpMessageID) throws IllegalArgumentException {
        this.setLongName(aLongName);
        this.setShortName(aShortName);
        this.setType(aType);
        this.setDefaultValues(aType, aDefaultValues, aShortName);
        this.helpMessageID = aHelpMessageID;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public int getType() {
        return this.type;
    }

    public String[] getDefaultValues() {
        return this.defaultValues;
    }

    public String getHelpMessage() {
        return CLIPSpec.getLocaleHelper().getLocalizedString(this.helpMessageID);
    }

    private void setLongName(String aLongName) {
        CLIPParser.verifyName(aLongName, "CLIPOption - Option's long name");
        this.longName = aLongName.trim();
    }

    private void setMandatory(String aDefaultValues) {
        this.mandatory = aDefaultValues == null || aDefaultValues.trim().equalsIgnoreCase("");
    }

    private void setShortName(String aShortName) {
        if (aShortName == null) {
            return;
        }
        if (aShortName.length() > 1) {
            throw new IllegalArgumentException("CLIPOption - Option's short name has to be undefined (NULL) or one character long");
        }
        if (aShortName.equals("-")) {
            throw new IllegalArgumentException("CLIPOption - Option's short name can not be '-'");
        }
        this.shortName = aShortName.trim();
    }

    private void setType(int aType) {
        this.type = aType;
    }

    private void setDefaultValues(int aType, String aDefaultValues, String aShortName) {
        this.setMandatory(aDefaultValues);
        if (this.isMandatory()) {
            return;
        }
        switch (aType) {
            case 0: {
                String value = aDefaultValues.trim();
                if (!value.equals("true") && !value.equals("false")) {
                    throw new IllegalArgumentException("CLIPOption - Boolean default value has to be 'true' or 'false'");
                }
                this.defaultValues = new String[1];
                this.defaultValues[0] = value;
                break;
            }
            case 1: {
                this.defaultValues = new String[1];
                this.defaultValues[0] = aDefaultValues;
                break;
            }
            case 2: {
                if (aShortName != null) {
                    throw new IllegalArgumentException("CLIPOption - Collection options can not have short names");
                }
                ArrayList<String> lCollection = new ArrayList<String>();
                String tokenSeparator = aDefaultValues.indexOf(" ") > -1 ? " " : ",";
                StringTokenizer tokens = new StringTokenizer(aDefaultValues, tokenSeparator);
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    lCollection.add(token);
                }
                this.defaultValues = new String[lCollection.size()];
                lCollection.toArray(this.defaultValues);
                break;
            }
            default: {
                throw new IllegalArgumentException("CLIPOption - Invalid type");
            }
        }
    }

    public String toString() {
        return "\nLongName : " + this.getLongName() + "\n" + "ShortName : " + this.getShortName() + "\n" + "Mandatory: " + this.isMandatory() + "\n" + "Type: " + this.getType() + "\n" + "DefaultValues: " + Arrays.asList(this.getDefaultValues()) + "\n" + "HelpMessage: " + this.getHelpMessage() + "\n";
    }

    public static void main(String[] args) {
        LocaleHelper.store("psrwCLI", LocaleHelper.getLocale(null));
        CLIPOption clipOption = new CLIPOption("version", null, 2, "a b c d e", "TestMessage");
        System.out.println(clipOption.getHelpMessage());
    }
}

