/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.test.util;

import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.rom.RuleSet;
import com.sun.portal.rewriter.rom.RuleSetManager;

public class CreateRuleSet {
    private static final String end = "</RuleSet>";

    private static String getStart() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE RuleSet SYSTEM \"jar://rewriter.jar/resources/RuleSet.dtd\">\n<RuleSet id=\"test_ruleset" + Math.round(Math.random() * 100000.0) + "\">";
    }

    public static RuleSet withJSVariableRules(String aXMLString) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "\t<JSRules>" + aXMLString + "</JSRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withJSFunctionRules(String aXMLString) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<JSRules>" + aXMLString + "</JSRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withHTMLAttributeRules(String aXMLString) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<HTMLRules>" + aXMLString + "</HTMLRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withXMLAttributeRules(String aXMLString) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<XMLRules>" + aXMLString + "</XMLRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withXMLTagTextRules(String aXMLString) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<XMLRules>" + aXMLString + "</XMLRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withXMLAttTagTextRules(String aAttRules, String aTagTextRules) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<XMLRules>" + aAttRules + aTagTextRules + "</XMLRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet emptyRuleSet() throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withHTMLAttJSVarRules(String htmlAtt, String jsVar) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<HTMLRules>" + htmlAtt + "</HTMLRules>" + "<JSRules>" + jsVar + "</JSRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withHTMLAttJSFunRules(String htmlAtt, String jsFun) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<HTMLRules>" + htmlAtt + "</HTMLRules>" + "<JSRules>" + jsFun + "</JSRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withHTMLJSTokenJSVarJSFunRules(String htmlJSToken, String jsVar, String jsFun) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<HTMLRules>" + htmlJSToken + "</HTMLRules>" + "<JSRules>" + jsVar + jsFun + "</JSRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withHTMLAttJSTokenJSVarJSFunRules(String htmlAtt, String htmlJSToken, String jsVar, String jsFun) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<HTMLRules>" + htmlJSToken + htmlAtt + "</HTMLRules>" + "<JSRules>" + jsVar + jsFun + "</JSRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withHTMLAttJSVarJSFunRules(String htmlAtt, String jsVar, String jsFun) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<HTMLRules>" + htmlAtt + "</HTMLRules>" + "<JSRules>" + jsVar + jsFun + "</JSRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withHTMLAttHTMLJSTokenJSVar(String htmlAtt, String htmlJSToken, String jsVar) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<HTMLRules>" + htmlAtt + htmlJSToken + "</HTMLRules>" + "<JSRules>" + jsVar + "</JSRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withHTMLAppletAttRules(String htmlAppletRules, String htmlAttRules) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<HTMLRules>" + htmlAppletRules + htmlAttRules + "</HTMLRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withHTMLAppletAttJSFunRules(String htmlAppletRules, String htmlAttRules, String jsFun) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<HTMLRules>" + htmlAppletRules + htmlAttRules + "</HTMLRules>" + "<JSRules>" + jsFun + "</JSRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withHTMLAppletAttJSVarJSFunRules(String htmlAppletRules, String htmlAttRules, String jsVar, String jsFun) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<HTMLRules>" + htmlAppletRules + htmlAttRules + "</HTMLRules>" + "<JSRules>" + jsVar + jsFun + "</JSRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withHTMLFormAttRules(String htmlFormRules, String htmlAttRules) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<HTMLRules>" + htmlFormRules + htmlAttRules + "</HTMLRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withHTMLAppletFormAttRules(String htmlAppletRules, String htmlFormRules, String htmlAttRules) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<HTMLRules>" + htmlAppletRules + htmlFormRules + htmlAttRules + "</HTMLRules>" + end;
        return RuleSetManager.create(xml);
    }

    public static RuleSet withHTMLFormJSRules(String htmlFormRules, String jsRules) throws InvalidXMLException {
        String xml = CreateRuleSet.getStart() + "<HTMLRules>" + htmlFormRules + "</HTMLRules>" + "<JSRules>" + jsRules + "</JSRules>" + end;
        return RuleSetManager.create(xml);
    }
}

