/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.services.idsame;

import com.iplanet.am.util.Debug;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class IDSAMELogHandler
extends Handler {
    private final Debug idsameHandler;

    public IDSAMELogHandler(String aFileName) {
        this.idsameHandler = Debug.getInstance((String)aFileName);
    }

    public void publish(LogRecord aLogRecord) {
        Level lLevel = aLogRecord.getLevel();
        Throwable lExpection = aLogRecord.getThrown();
        if (lExpection == null) {
            if (lLevel == Level.FINEST) {
                this.idsameHandler.message(aLogRecord.getMessage());
            } else if (lLevel == Level.WARNING) {
                this.idsameHandler.warning(aLogRecord.getMessage());
            } else if (lLevel == Level.SEVERE) {
                this.idsameHandler.error(aLogRecord.getMessage());
            }
        } else if (lLevel == Level.FINEST) {
            this.idsameHandler.message(aLogRecord.getMessage(), lExpection);
        } else if (lLevel == Level.WARNING) {
            this.idsameHandler.warning(aLogRecord.getMessage(), lExpection);
        } else if (lLevel == Level.SEVERE) {
            this.idsameHandler.error(aLogRecord.getMessage(), lExpection);
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
        this.idsameHandler.destroy();
    }

    public Level getLevel() {
        if (this.idsameHandler.messageEnabled()) {
            return Level.FINEST;
        }
        if (this.idsameHandler.warningEnabled()) {
            return Level.WARNING;
        }
        if (this.idsameHandler.getState() == 1) {
            return Level.SEVERE;
        }
        if (this.idsameHandler.getState() == 0) {
            return Level.OFF;
        }
        return super.getLevel();
    }
}

