/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.rom.common;

import com.sun.portal.rewriter.rom.Data;
import com.sun.portal.rewriter.rom.DataRule;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.collections.ListMap;
import com.sun.portal.rewriter.util.re.Pattern;

public final class TagText
extends Data {
    private String tag;
    private String attributePatterns;
    private ListMap attributeMap;

    public TagText(String aTag) {
        this(aTag, (String)null, null);
    }

    public TagText(String aTag, String aAttributePatterns, String aSource) {
        this(aTag, TagText.parseAttributes(StringHelper.normalize(aAttributePatterns)), aSource);
        this.attributePatterns = StringHelper.normalize(aAttributePatterns);
    }

    public TagText(String aTag, ListMap aAttributeMap, String aSource) {
        super("TagText", aSource);
        this.tag = StringHelper.normalize(aTag);
        this.attributeMap = aAttributeMap != null ? aAttributeMap : ListMap.EMPTY_LISTMAP;
        if (this.attributePatterns == null) {
            this.attributePatterns = this.attributeMap.toString();
        }
    }

    public String getTag() {
        return this.tag;
    }

    public String getAttributePatterns() {
        return this.attributePatterns;
    }

    ListMap getAttributeMap() {
        return this.attributeMap;
    }

    public TagText recycleMatchee(String aTag, ListMap aAttributePatternsMap, String aSource) {
        this.tag = aTag;
        this.attributeMap = aAttributePatternsMap;
        this.setSource(aSource);
        return this;
    }

    public void writeCustomAttributes(StringBuffer aBuffer) {
        aBuffer.append("tag").append("=").append("\"").append(this.getTag()).append("\"");
        if (this.getAttributePatterns().length() > 0) {
            aBuffer.append(" ").append("attributePatterns").append("=").append("\"").append(this.getAttributePatterns()).append("\"");
        }
    }

    static final ListMap parseAttributes(String aAttributePatterns) {
        Pattern[] c = DataRule.createValuePatternSpec(aAttributePatterns);
        ListMap result = new ListMap();
        for (int i = 0; i < c.length; ++i) {
            String[] temp = StringHelper.tokenize(c[i].getInput(), "=", true, 2);
            result.put(temp[0].trim(), temp[1].trim());
        }
        return result;
    }
}

