/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.rom.common;

import com.sun.portal.rewriter.rom.Data;
import com.sun.portal.rewriter.rom.DataRule;
import com.sun.portal.rewriter.rom.common.Attribute;
import com.sun.portal.rewriter.test.util.SampleRuleObjects;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.re.Pattern;
import com.sun.portal.rewriter.util.xml.Node;

public final class AttributeRule
extends DataRule {
    public static final String JSTOKEN = "JSToken";
    private final Attribute attribute;
    private final Pattern[] nameSpec;
    private final Pattern[] tagSpec;
    private final Pattern[] valuePatternSpec;

    public AttributeRule(Attribute aAttribute) {
        this(aAttribute, true);
    }

    public AttributeRule(Attribute aAttribute, boolean aIgnoreCase) {
        super(aAttribute);
        this.attribute = aAttribute;
        this.nameSpec = AttributeRule.createAttributeSpec(this.attribute.getName(), aIgnoreCase);
        this.tagSpec = AttributeRule.createAttributeSpec(this.attribute.getTag(), aIgnoreCase);
        this.valuePatternSpec = AttributeRule.createValuePatternSpec(this.attribute.getValuePatterns());
    }

    public AttributeRule(Node aNode, boolean aIgnoreCase) {
        this(AttributeRule.createAttribute(aNode), aIgnoreCase);
    }

    private static final Attribute createAttribute(Node aNode) {
        if (aNode.getName().equals(JSTOKEN)) {
            return new Attribute(aNode.getPCData(), null, null, "DJS", null);
        }
        return new Attribute(aNode.getAttributeValue("name"), aNode.getAttributeValue("tag"), aNode.getAttributeValue("valuePatterns"), aNode.getAttributeValue("type"), aNode.getAttributeValue("source"));
    }

    public Pattern[] getParsedPatterns() {
        return this.valuePatternSpec;
    }

    public boolean plugableMatch(Data aMache) {
        if (!(aMache instanceof Attribute)) {
            return false;
        }
        Attribute valueObject = (Attribute)aMache;
        return AttributeRule.match(this.nameSpec, valueObject.getName()) && AttributeRule.match(this.tagSpec, valueObject.getTag());
    }

    public boolean isValid() {
        return AttributeRule.doBasicValidation(new String[]{this.attribute.getName()});
    }

    public static final AttributeRule[] createAttributeRules(Node[] aNodeList, boolean aIgnoreCase) {
        AttributeRule[] lResult = new AttributeRule[aNodeList.length];
        for (int i = 0; i < aNodeList.length; ++i) {
            lResult[i] = new AttributeRule(aNodeList[i], aIgnoreCase);
        }
        return lResult;
    }

    public static void main(String[] args) {
        AttributeRule[] attributes = SampleRuleObjects.defaultHTMLAttributes;
        for (int i = 0; i < attributes.length; ++i) {
            Debug.println(attributes[i].toXML());
        }
    }
}

