/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.rom;

import com.sun.portal.rewriter.rom.InvalidCollectionIDException;
import com.sun.portal.rewriter.util.StringHelper;

public abstract class Data {
    private static final String[] messages = new String[]{"Collection Type can't be "};
    private final String collectionID;
    private String source;

    protected Data(String aCollectionID, String aSource) {
        if (aCollectionID == null || aCollectionID.trim().length() == 0) {
            throw new InvalidCollectionIDException(messages[0] + aCollectionID);
        }
        this.collectionID = aCollectionID;
        this.source = StringHelper.normalize(aSource, "*");
    }

    public final String getCollectionID() {
        return this.collectionID;
    }

    public String getSource() {
        return this.source;
    }

    protected void setSource(String aSource) {
        this.source = StringHelper.normalize(aSource);
    }

    public abstract void writeCustomAttributes(StringBuffer var1);

    public final String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<").append(this.collectionID).append(" ");
        this.writeCustomAttributes(sb);
        if (!this.getSource().equals("*")) {
            sb.append(" ").append("source").append("=").append("\"").append(this.getSource()).append("\"");
        }
        sb.append(" ").append("/>").append("\n");
        return sb.toString();
    }

    public final String toString() {
        return this.toXML();
    }
}

