/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.db;

import com.sun.kt.search.Passage;
import com.sun.kt.search.Result;
import com.sun.kt.search.ResultSet;
import com.sun.portal.search.db.NovaDb;
import com.sun.portal.search.db.RDMDb;
import com.sun.portal.search.db.RDMResultSet;
import com.sun.portal.search.db.SToken;
import com.sun.portal.search.rdm.RDMException;
import com.sun.portal.search.rdm.RDMTransaction;
import com.sun.portal.search.soif.AVPair;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.util.CSLog;
import com.sun.portal.search.util.Encoder;
import com.sun.portal.search.util.SearchConfig;
import com.sun.portal.search.util.String2Array;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NovaResultSet
extends RDMResultSet {
    static DecimalFormat scoreForm = new DecimalFormat("###0.000");
    protected String dbkey = "URL";
    protected int resultCount;
    protected long hitCount;
    protected long docCount;
    protected List hits;
    static String[] defaultHighlightTags = new String[]{"... ", " ...", "<font color=bb0033>", "</font>", "<b>", "</b>"};
    static int defaultMaxPassages = 3;
    static int defaultPassageContext = 6;
    static int defaultPassageSize = 500;
    static String[] defaultFldHighlightTags = new String[]{"", "", "", "", "<b>", "</b>"};
    static int defaultFldMaxPassages = 1;
    static int defaultFldPassageContext = -1;
    static int defaultFldPassageSize = 150;
    static int defaultSummaryFromBody = 0;
    static boolean highlightsEnabled = true;
    static boolean hlInited = false;

    public NovaResultSet(SToken sToken, RDMDb rDMDb, String string, ResultSet resultSet, int n, int n2, RDMTransaction rDMTransaction) {
        super(sToken, rDMDb, string, rDMTransaction);
        if (resultSet != null) {
            try {
                this.hits = resultSet.getResults(0, n);
                this.hitCount = resultSet.size();
            }
            catch (Exception exception) {
                CSLog.error(1, 1, "Error when retrieving results");
            }
        }
        this.resultCount = this.hits.size();
        this.docCount = n2;
    }

    public SOIF getResult(int n, Set set, String[] stringArray) {
        if (this.hits.size() == 0) {
            return null;
        }
        Result result = (Result)this.hits.get(n);
        SOIF sOIF = this.highlight(result, set, stringArray);
        return sOIF;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getDocCount() {
        return this.docCount;
    }

    public String toString() {
        return super.toString();
    }

    public Result getHit(int n) {
        return (Result)this.hits.get(n);
    }

    private void buildHighlightInfo(Result result, SOIF sOIF, Set set, String[] stringArray, int n, int n2, int n3, String[] stringArray2, int n4, int n5, int n6, int n7) {
        int n8;
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        boolean bl = true;
        if (!bl && result.getNPassages() <= 0) {
            return;
        }
        boolean bl2 = set.contains("hit-terms");
        boolean bl3 = set.contains("highlight-positions");
        boolean bl4 = set.contains("passage");
        boolean bl5 = set.contains("passage-score");
        boolean bl6 = false;
        boolean bl7 = set.contains("passage-count");
        boolean bl8 = !bl3;
        boolean bl9 = set.contains("hl-description");
        boolean bl10 = false;
        Object object5 = set.iterator();
        while (object5.hasNext()) {
            object4 = (String)object5.next();
            if (((String)object4).equalsIgnoreCase("hl-description")) {
                result.addPassageField("NonField", 1, n, n2, true);
                continue;
            }
            if (!((String)object4).regionMatches(true, 0, "hl-", 0, 3)) continue;
            result.addPassageField(((String)object4).substring(3), 2, n4, n5, bl10);
        }
        object5 = result.getPassages(NovaDb.soifToIndexableMap(sOIF), true, 1, n, n5, true);
        if (object5 != null) {
            object4 = object5.entrySet().iterator();
            while (object4.hasNext()) {
                StringBuffer stringBuffer;
                int[] nArray;
                String string2;
                Passage passage;
                Iterator iterator;
                object3 = (Map.Entry)object4.next();
                string = (String)object3.getKey();
                object2 = (List)object3.getValue();
                if (string == null || string.equalsIgnoreCase("NonField")) {
                    object = new StringBuffer();
                    iterator = object2.iterator();
                    for (n8 = 0; n8 < n3 && iterator.hasNext(); ++n8) {
                        int n9;
                        passage = (Passage)iterator.next();
                        passage.highlightPassage(null);
                        string2 = passage.getHLValue(true);
                        nArray = passage.getPassageWordPositions();
                        if (bl9 || bl8) {
                            stringBuffer = new StringBuffer();
                            n9 = 0;
                            String string3 = null;
                            stringBuffer.append(stringArray[0]);
                            for (int i = 0; i < nArray.length; i += 2) {
                                string3 = string2.substring(n9, nArray[i]);
                                Encoder.htmlEncode(string3, stringBuffer);
                                if (i == 0) {
                                    stringBuffer.append(stringArray[2]);
                                }
                                stringBuffer.append(stringArray[4]);
                                string3 = string2.substring(nArray[i], nArray[i + 1]);
                                Encoder.htmlEncode(string3, stringBuffer);
                                stringBuffer.append(stringArray[5]);
                                if (i == nArray.length - 2) {
                                    stringBuffer.append(stringArray[3]);
                                }
                                n9 = nArray[i + 1];
                            }
                            string3 = string2.substring(n9, string2.length());
                            Encoder.htmlEncode(string3, stringBuffer);
                            stringBuffer.append(stringArray[1]);
                            if (bl4) {
                                sOIF.replace("passage", bl8 ? stringBuffer.toString() : string2, n8);
                            }
                            if (bl9) {
                                if (bl6) {
                                    ((StringBuffer)object).append("[" + scoreForm.format(passage.getScore()) + "]&nbsp;&nbsp;");
                                }
                                ((StringBuffer)object).append(stringBuffer.toString());
                                if (n8 < n3 - 1 && iterator.hasNext()) {
                                    ((StringBuffer)object).append("<br>");
                                }
                            }
                        }
                        if (bl5) {
                            sOIF.replace("passage-score", scoreForm.format(passage.getScore()), n8);
                        }
                        if (bl3) {
                            stringBuffer = new StringBuffer();
                            for (n9 = 0; n9 < nArray.length; ++n9) {
                                if (n9 > 0) {
                                    stringBuffer.append(",");
                                }
                                stringBuffer.append(nArray[n9]);
                            }
                            sOIF.replace("highlight-positions", stringBuffer.toString(), n8);
                        }
                        if (bl2) {
                            stringBuffer = new StringBuffer();
                            String[] stringArray3 = passage.getMatchingTerms();
                            for (int i = 0; i < stringArray3.length; ++i) {
                                String string4 = stringArray3[i];
                                if (string4 == null) continue;
                                if (i > 0) {
                                    stringBuffer.append(",");
                                }
                                stringBuffer.append(stringArray3[i]);
                            }
                            sOIF.replace("hit-terms", stringBuffer.toString(), n8);
                        }
                        if (!bl7) continue;
                        sOIF.replace("passage-count", String.valueOf(result.getNPassages()));
                    }
                    if (!bl9 || ((StringBuffer)object).length() <= 0) continue;
                    sOIF.replace("hl-description", ((StringBuffer)object).toString());
                    continue;
                }
                object = new StringBuffer();
                n8 = 0;
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    passage = (Passage)iterator.next();
                    passage.highlightPassage(null);
                    string2 = passage.getHLValue(true);
                    nArray = passage.getPassageWordPositions();
                    if (bl9 || bl8) {
                        stringBuffer = new StringBuffer();
                        int n10 = 0;
                        String string5 = null;
                        stringBuffer.append(stringArray2[0]);
                        for (int i = 0; i < nArray.length; i += 2) {
                            string5 = string2.substring(n10, nArray[i]);
                            Encoder.htmlEncode(string5, stringBuffer);
                            if (i == 0) {
                                stringBuffer.append(stringArray2[2]);
                            }
                            stringBuffer.append(stringArray2[4]);
                            string5 = string2.substring(nArray[i], nArray[i + 1]);
                            Encoder.htmlEncode(string5, stringBuffer);
                            stringBuffer.append(stringArray2[5]);
                            if (i == nArray.length - 2) {
                                stringBuffer.append(stringArray2[3]);
                            }
                            n10 = nArray[i + 1];
                        }
                        string5 = string2.substring(n10, string2.length());
                        Encoder.htmlEncode(string5, stringBuffer);
                        stringBuffer.append(stringArray2[1]);
                        if (bl4) {
                            sOIF.replace("passage-" + string, bl8 ? stringBuffer.toString() : string2, n8);
                        }
                        if (bl9) {
                            if (bl6) {
                                ((StringBuffer)object).append("[" + scoreForm.format(passage.getScore()) + "]&nbsp;&nbsp;");
                            }
                            ((StringBuffer)object).append(stringBuffer.toString());
                            if (n8 < n6 - 1 && iterator.hasNext()) {
                                ((StringBuffer)object).append("<br>");
                            }
                        }
                    }
                    if (bl5) {
                        sOIF.replace("passage-score-" + string, scoreForm.format(passage.getScore()), n8);
                    }
                    if (bl3) {
                        stringBuffer = new StringBuffer();
                        for (int i = 0; i < nArray.length; ++i) {
                            if (i > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(nArray[i]);
                        }
                        sOIF.replace("highlight-positions-" + string, stringBuffer.toString(), n8);
                    }
                    if (bl2) {
                        stringBuffer = new StringBuffer();
                        String[] stringArray4 = passage.getMatchingTerms();
                        for (int i = 0; i < stringArray4.length; ++i) {
                            String string6 = stringArray4[i];
                            if (string6 == null) continue;
                            if (i > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(stringArray4[i]);
                        }
                        sOIF.replace("hit-terms-" + string, stringBuffer.toString(), n8);
                    }
                    if (bl7) {
                        sOIF.replace("passage-count-" + string, String.valueOf(result.getNPassages()));
                    }
                    if (bl9 && ((StringBuffer)object).length() > 0) {
                        sOIF.replace("hl-" + string, ((StringBuffer)object).toString(), n8);
                    }
                    ((StringBuffer)object).setLength(0);
                    ++n8;
                }
            }
        }
        if (object5 == null || set.contains("hl-description") && !sOIF.contains("hl-description")) {
            object4 = set.iterator();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                if (!((String)object3).regionMatches(true, 0, "hl-", 0, 3) || sOIF.contains((String)object3)) continue;
                string = ((String)object3).substring(3);
                if (string.equalsIgnoreCase("url")) {
                    sOIF.replace((String)object3, sOIF.getURL());
                    continue;
                }
                object2 = sOIF.getAVPair(string);
                if (object2 == null) continue;
                if (set.contains(string)) {
                    object = new AVPair((String)object3);
                    for (n8 = 0; n8 <= ((AVPair)object2).getMaxIndex(); ++n8) {
                        ((AVPair)object).insert(((AVPair)object2).getValue(n8), n8);
                    }
                    sOIF.replace((AVPair)object);
                    continue;
                }
                sOIF.rename(string, (String)object3);
            }
        }
        if (!(n7 <= 0 || sOIF.getValue("summary") != null || set.contains("description") && sOIF.getValue("description") != null || (object4 = sOIF.getValue("partial-text")) == null)) {
            sOIF.replace("description", ((String)object4).substring(0, n7) + "...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SOIF highlight(Result result, Set set, String[] stringArray) {
        if (!hlInited) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                NovaResultSet.hlInit();
                hlInited = true;
            }
        }
        boolean bl = false;
        if (set != null && set.contains("hl-description")) {
            bl = true;
        }
        boolean bl2 = highlightsEnabled && bl;
        String string = (String)result.getField(this.dbkey);
        if (string == null) {
            CSLog.error(1, 1, "Search hit has no db key");
            return null;
        }
        Set set2 = bl2 ? null : set;
        SOIF sOIF = null;
        try {
            sOIF = this.getDb().fetch(this.getSToken(), string, set2, 0, this.getTransaction());
        }
        catch (RDMException rDMException) {
            CSLog.error(1, 1, "Exception when reading db: ", rDMException);
        }
        if (sOIF == null) {
            CSLog.error(1, 1, "Search hit not found in db: " + string);
            return null;
        }
        String[] stringArray2 = (String[])defaultHighlightTags.clone();
        String[] stringArray3 = (String[])defaultFldHighlightTags.clone();
        if (stringArray != null && stringArray.length >= 6) {
            System.arraycopy(stringArray, 0, stringArray2, 0, 6);
        }
        if (stringArray != null && stringArray.length == 12) {
            System.arraycopy(stringArray, 6, stringArray3, 0, 6);
        }
        if (bl2) {
            this.buildHighlightInfo(result, sOIF, set, stringArray2, defaultPassageContext, defaultPassageSize, defaultMaxPassages, stringArray3, defaultFldPassageContext, defaultFldPassageSize, defaultFldMaxPassages, defaultSummaryFromBody);
        }
        if (set != null && bl2) {
            Iterator iterator = sOIF.keySet().iterator();
            while (iterator.hasNext()) {
                if (set.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
        if (set == null || set.contains("score")) {
            sOIF.replace("score", "" + Math.round(result.getScore() * 100.0f));
        }
        return sOIF;
    }

    static void hlInit() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String[] stringArray;
        String string = SearchConfig.getValue("search-highlights");
        if (string != null) {
            highlightsEnabled = string.equalsIgnoreCase("true");
        }
        if ((string = SearchConfig.getValue("search-highlight-tags")) != null && (stringArray = String2Array.string2Array(string, ',')) != null && stringArray.length == 6) {
            defaultHighlightTags = stringArray;
        }
        if ((string = SearchConfig.getValue("search-passage-context")) != null && (n6 = Integer.parseInt(string)) > 0) {
            defaultPassageContext = n6;
        }
        if ((string = SearchConfig.getValue("search-passage-size")) != null && (n5 = Integer.parseInt(string)) > 0) {
            defaultPassageSize = n5;
        }
        if ((string = SearchConfig.getValue("search-max-passages")) != null && (n4 = Integer.parseInt(string)) > 0) {
            defaultMaxPassages = n4;
        }
        if ((string = SearchConfig.getValue("search-highlight-tags-field")) != null && (stringArray = String2Array.string2Array(string, ',')) != null && stringArray.length == 6) {
            defaultFldHighlightTags = stringArray;
        }
        if ((string = SearchConfig.getValue("search-passage-context-field")) != null && (n3 = Integer.parseInt(string)) > 0) {
            defaultFldPassageContext = n3;
        }
        if ((string = SearchConfig.getValue("search-passage-size-field")) != null && (n2 = Integer.parseInt(string)) > 0) {
            defaultFldPassageSize = n2;
        }
        if ((string = SearchConfig.getValue("search-max-passages-field")) != null && (n = Integer.parseInt(string)) > 0) {
            defaultFldMaxPassages = n;
        }
        if ((string = SearchConfig.getValue("search-summary-from-body")) != null) {
            try {
                int n7 = Integer.parseInt(string);
                if (n7 > 0) {
                    defaultSummaryFromBody = n7;
                }
            }
            catch (Exception exception) {
                CSLog.error(1, 1, "Illegal value for: search-summary-from-body");
            }
        }
    }
}

