/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.ab.exchange;

import com.aligo.pim.interfaces.PimAddressBook;
import com.sun.addressbook.ABFilter;
import com.sun.addressbook.ABStore;
import com.sun.addressbook.ABStoreException;
import com.sun.addressbook.Element;
import com.sun.addressbook.Group;
import com.sun.addressbook.OperationNotSupportedException;
import com.sun.ssoadapter.ab.pim.JPimABStore;
import com.sun.ssoadapter.ab.pim.JPimAddressBook;

public class ExchangeAddressBook
extends JPimAddressBook {
    private String pimInterfaceType = "cdo";

    public ExchangeAddressBook(ABStore store, PimAddressBook pBook, String abID) {
        super(store, pBook, abID);
        this.jPimStore = (JPimABStore)store;
        String tmp = this.jPimStore.getSession().getProperty("ab.pimInterfaceType");
        if (tmp != null && tmp.equals("webdav")) {
            this.pimInterfaceType = "webdav";
        }
    }

    public void add(Element element) throws ABStoreException, OperationNotSupportedException {
        System.out.println("In Exchange add : element type = " + element.getElementType() + ", piminterfaceType = " + this.pimInterfaceType);
        if (element.getElementType() == 2) {
            if (this.pimInterfaceType.equals("cdo")) {
                String msg = "Exchange CDO Container does not support groups";
                System.out.println("ExchangeAddressBook.add() : Throwing OperationNotSupportedException");
                throw new OperationNotSupportedException(msg);
            }
            super.add(element);
        } else {
            super.add(element);
        }
    }

    public void modify(Element oldElement, Element newElement) throws ABStoreException, OperationNotSupportedException {
        if (newElement.getElementType() == 2) {
            if (this.pimInterfaceType.equals("cdo")) {
                String msg = "Exchange CDO Container does not support groups";
                System.out.println("ExchangeAddressBook.modify() : Throwing OperationNotSupportedException");
                throw new OperationNotSupportedException(msg);
            }
            super.modify(oldElement, newElement);
        } else {
            super.modify(oldElement, newElement);
        }
    }

    public Element[] fetchGroupMembers(ABFilter filter, Group group) throws ABStoreException, OperationNotSupportedException {
        if (this.pimInterfaceType.equals("cdo")) {
            String msg = "Exchange CDO Container does not support groups";
            throw new OperationNotSupportedException(msg);
        }
        return super.fetchGroupMembers(filter, group);
    }

    public void addGroupMember(Element element, Group group) throws ABStoreException, OperationNotSupportedException {
        if (this.pimInterfaceType.equals("cdo")) {
            String msg = "Exchange CDO Container does not support groups";
            System.out.println("ExchangeAddressBook.addGroupMember() : Throwing OperationNotSupportedException");
            throw new OperationNotSupportedException(msg);
        }
        super.addGroupMember(element, group);
    }

    public void deleteGroupMember(Element element, Group group) throws ABStoreException, OperationNotSupportedException {
        if (this.pimInterfaceType.equals("cdo")) {
            String msg = "Exchange CDO Container does not support groups";
            System.out.println("ExchangeAddressBook.deleteGroupMember() : Throwing OperationNotSupportedException");
            throw new OperationNotSupportedException(msg);
        }
        super.deleteGroupMember(element, group);
    }
}

