/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.impl;

import com.sun.portal.common.logging.Level;
import com.sun.portal.common.logging.Logger;
import com.sun.portal.portletcontainercommon.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class PortletsResources {
    private Map _portletResourceMap = null;
    private PortletAppDescriptor _portletAppD = null;
    private Logger _logger = null;

    public PortletsResources(PortletAppDescriptor pd, Logger logger) {
        this._portletAppD = pd;
        this._logger = logger;
        this.init();
    }

    private void init() {
        List portlets;
        if (this.getPortletAppD() != null && (portlets = this.getPortletNames()) != null) {
            this._portletResourceMap = new HashMap();
            Iterator iter = portlets.iterator();
            while (iter.hasNext()) {
                String portlet = (String)iter.next();
                this.loadResources(portlet);
            }
        }
    }

    private void loadResources(String portlet) {
        HashMap<String, ResourceBundle> resBundleMap = new HashMap<String, ResourceBundle>();
        String rbName = this.getResourceBundleName(portlet);
        if (rbName != null) {
            ResourceBundle bundle;
            List locales = this.getSupportedLocales(portlet);
            if (locales != null && locales.size() > 0) {
                Iterator iter = locales.iterator();
                while (iter.hasNext()) {
                    Locale thisLocale;
                    ResourceBundle bundle2;
                    String locale = (String)iter.next();
                    String lang = "";
                    String country = "";
                    String variant = "";
                    StringTokenizer tokenizer = new StringTokenizer(locale, "_");
                    lang = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        country = tokenizer.nextToken();
                    }
                    if (tokenizer.hasMoreTokens()) {
                        variant = tokenizer.nextToken();
                    }
                    if ((bundle2 = this.loadResource(rbName, thisLocale = new Locale(lang, country, variant))) == null) continue;
                    resBundleMap.put(thisLocale.toString(), bundle2);
                }
            }
            if ((bundle = this.loadResource(rbName, Locale.getDefault())) != null) {
                resBundleMap.put(Locale.getDefault().toString(), bundle);
            }
            this._portletResourceMap.put(portlet, resBundleMap);
        }
    }

    private ResourceBundle loadResource(String rbName, Locale locale) {
        ResourceBundle retval = null;
        try {
            retval = locale != null ? ResourceBundle.getBundle(rbName, locale) : ResourceBundle.getBundle(rbName);
        }
        catch (MissingResourceException ex) {
            if (this._logger.isLoggable(Level.WARNING)) {
                this._logger.logp(Level.WARNING, "PortletResources", "loadResource()", "Resource" + rbName + "   NOT found");
            }
            retval = null;
        }
        return retval;
    }

    public Map getPortletResourceMap() {
        return this._portletResourceMap;
    }

    private PortletAppDescriptor getPortletAppD() {
        return this._portletAppD;
    }

    private PortletDescriptor getPortletDescriptor(String portlet) {
        return this.getPortletAppD().getPortletsDescriptor().getPortletDescriptor(portlet);
    }

    private List getSupportedLocales(String portlet) {
        return this.getPortletDescriptor(portlet).getSupportedLocales();
    }

    private String getResourceBundleName(String portlet) {
        return this.getPortletDescriptor(portlet).getResourceBundle();
    }

    private List getPortletNames() {
        return this.getPortletAppD().getPortletsDescriptor().getPortletNames();
    }
}

