/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.impl;

import com.sun.portal.common.logging.Logger;
import com.sun.portal.container.ChannelMode;
import com.sun.portal.portlet.impl.PortletRequestImpl;
import com.sun.portal.portletappengine.PortletAppEngineUtils;
import com.sun.portal.portletcontainercommon.PortletContainerActionRequest;
import com.sun.portal.portletcontainercommon.PortletContainerActionResponse;
import com.sun.portal.portletcontainercommon.PortletContainerRequest;
import com.sun.portal.portletcontainercommon.PortletContainerResponse;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ActionRequestImpl
extends PortletRequestImpl
implements ActionRequest {
    private HttpServletRequest _req;
    private HttpServletResponse _res;
    private PortletContainerActionRequest _pContReq;
    private PortletContainerActionResponse _pContRes;
    private StringWriter _writer;
    private Logger _logger;
    private boolean _gotReader;
    private boolean _gotInputStream;
    private static String ILLEGAL_OPERATION_ERROR = "Can not perform this function for portlet: ";
    private static String UNSUPPORTED_ENCODING_ERROR = "The specified character encoding is not supported.";

    void init(HttpServletRequest req, HttpServletResponse res, PortletContainerActionRequest pContReq, PortletContainerActionResponse pContRes, PortletContext context, PortalContext portalContext, PortletDescriptor pDescriptor, StringWriter writer, Logger logger) {
        super.init(req, res, (PortletContainerRequest)pContReq, (PortletContainerResponse)pContRes, context, portalContext, pDescriptor, logger);
        this._req = req;
        this._res = res;
        this._pContReq = pContReq;
        this._pContRes = pContRes;
        this._writer = writer;
        this._logger = logger;
        this._gotReader = false;
        this._gotInputStream = false;
    }

    void clear() {
        super.clear();
        this._req = null;
        this._res = null;
        this._pContReq = null;
        this._pContRes = null;
        this._writer = null;
        this._logger = null;
        this._gotReader = false;
        this._gotInputStream = false;
    }

    public InputStream getPortletInputStream() throws IOException {
        if (this._gotReader) {
            throw new IllegalStateException(ILLEGAL_OPERATION_ERROR + this._pContReq.getPortletName());
        }
        if (this.getContentType() != null && this.getContentType().equals("application/x-www-form-urlencoded")) {
            throw new IllegalStateException(ILLEGAL_OPERATION_ERROR + this._pContReq.getPortletName());
        }
        this._gotInputStream = true;
        return this._req.getInputStream();
    }

    public String getCharacterEncoding() {
        return this._pContReq.getCharacterEncoding();
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this._gotReader || this._gotInputStream) {
            throw new IllegalStateException("Illegal setting character encoding after getReader() or getPortletInputStream() is called");
        }
        if (!enc.equals(this.getCharacterEncoding())) {
            throw new UnsupportedEncodingException(UNSUPPORTED_ENCODING_ERROR);
        }
        this._req.setCharacterEncoding(enc);
    }

    public String getContentType() {
        return this._req.getContentType();
    }

    public int getContentLength() {
        int retVal = -1;
        if (this.getContentType() != null && !this.getContentType().equals("application/x-www-form-urlencoded")) {
            retVal = this._req.getContentLength();
        }
        return retVal;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        if (this._gotInputStream) {
            throw new IllegalStateException("Can not perform this function for portlet: " + this._pContReq.getPortletName());
        }
        if (this.getContentType() != null && this.getContentType().equals("application/x-www-form-urlencoded")) {
            throw new IllegalStateException("Can not perform this function for portlet: " + this._pContReq.getPortletName());
        }
        this._gotReader = true;
        return this._req.getReader();
    }

    public Map getParameterMap() {
        Map map = this._pContReq.getActionParameters();
        return Collections.unmodifiableMap(map);
    }

    public PortletMode getPortletMode() {
        ChannelMode channelMode = this._pContRes.getNewChannelMode();
        PortletMode portletMode = null;
        portletMode = channelMode != null ? PortletAppEngineUtils.getPortletMode(channelMode) : PortletAppEngineUtils.getPortletMode(this._pContReq.getChannelMode());
        return portletMode;
    }

    public WindowState getWindowState() {
        com.sun.portal.container.WindowState newWindowState = this._pContRes.getNewWindowState();
        WindowState windowState = null;
        windowState = newWindowState != null ? PortletAppEngineUtils.getWindowState(newWindowState) : PortletAppEngineUtils.getWindowState(this._pContReq.getWindowState());
        return windowState;
    }
}

