/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.xslutil;

import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLErrorHandler
implements ErrorHandler {
    private XSLXMLLogHandler _logHandler;

    XMLErrorHandler(XSLXMLLogHandler logHandler) {
        this._logHandler = logHandler;
    }

    public void warning(SAXParseException spe) throws SAXException {
        this._logHandler.error("Warning: " + this.getParseExceptionInfo(spe));
    }

    public void error(SAXParseException spe) throws SAXException {
        String message = "Error: " + this.getParseExceptionInfo(spe);
        this._logHandler.error(message);
        throw new SAXException(message);
    }

    public void fatalError(SAXParseException spe) throws SAXException {
        String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
        this._logHandler.error(message);
        throw new SAXException(message);
    }

    private String getParseExceptionInfo(SAXParseException spe) {
        String systemId = spe.getSystemId();
        if (systemId == null) {
            systemId = "null";
        }
        String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
        return info;
    }
}

