/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.auth.UserSessionFactory;
import com.iplanet.xslui.auth.XSLAuthFilter;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SimpleAuthFilter
extends XSLAuthFilter {
    public static final String CONFIG_FILENAME = "xslauth.properties";
    public static final String CONFIG_USERSESSION_PREFIX = "usersession";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    private UserSessionFactory _userFactory = null;
    private String _defaultDomain = null;

    public void init(FilterConfig config) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(config);
        PropertyReader propertyReader = super.getPropertyReader();
        this._defaultDomain = propertyReader.getStringProperty(CONFIG_DEFAULTDOMAIN, "iplanet.com");
        try {
            this._userFactory = (UserSessionFactory)propertyReader.getObjectProperty(CONFIG_USERSESSION_PREFIX, true);
        }
        catch (Exception ex) {
            throw new ServletException("Cant initialize UserSessionFactory:" + ex.getMessage());
        }
    }

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpSession session = request.getSession(true);
        UserSession userSession = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
        if (userSession != null) {
            chain.doFilter(req, response);
            if (XSLAuthFilter.invalidateSession(request)) {
                session.invalidate();
            }
            return;
        }
        String uid = (String)session.getAttribute("uid");
        String domain = (String)session.getAttribute("domainname");
        if (domain == null || domain.length() <= 0) {
            session.setAttribute("domainname", (Object)this._defaultDomain);
        }
        boolean needAuth = true;
        if (uid != null && uid.length() > 0 && domain != null && domain.length() > 0) {
            needAuth = false;
        } else {
            String login = XSLAuthFilter.getUserFromRequest(request);
            if (login == null) {
                chain.doFilter(req, response);
                return;
            }
            int sep = login.lastIndexOf("@");
            if (sep != -1) {
                uid = login.substring(0, sep);
                domain = login.substring(sep + 1);
            } else {
                uid = login;
                domain = this._defaultDomain;
            }
        }
        userSession = this._userFactory.newUserSession(uid, domain);
        if (userSession == null) {
            Logging.trace(8, "couldnt create user " + uid + "(domain " + domain + ")");
            chain.doFilter(req, response);
            return;
        }
        if (!needAuth || !uid.equals("anonymous")) {
            String passwdParam = XSLAuthFilter.getPasswordFromRequest(request);
            String passwd = userSession.getUserAttrib("password");
            if (passwd != null && !passwd.equals(passwdParam) || passwd == null && passwdParam != null) {
                chain.doFilter(req, response);
                return;
            }
            session.setAttribute("uid", (Object)uid);
            session.setAttribute("domainname", (Object)domain);
            Logging.trace(64, "SimpleAuthFilter: user " + uid + "@" + domain + " authenticated");
        }
        session.setAttribute("com.iplanet.xslui.ui.clientIP", (Object)request.getRemoteAddr());
        String lang = userSession.getPreferredLanguage();
        session.setAttribute("userlang", (Object)lang);
        session.setAttribute("com.iplanet.xslui.ui.usersession", (Object)userSession);
        Logging.trace(64, "SimpleAuthFilter: user " + uid + "@" + domain + " session created");
        chain.doFilter(req, response);
        if (XSLAuthFilter.invalidateSession(request)) {
            session.invalidate();
        }
    }

    public void destroy() {
    }
}

