/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public class MessagingSSO {
    public static final String CONFIG_SSO_PREFIX = "messagingsso.";
    public static final String CONFIG_ENABLE = "enable";
    public static final String CONFIG_SESSIONCOOKIE = "sessioncookie";
    public static final String CONFIG_APPPREFIX = "appprefix";
    public static final String CONFIG_APPID = "appid";
    public static final String CONFIG_COOKIEDOMAIN = "cookiedomain";
    public static final String CONFIG_COOKIEPATH = "cookiepath";
    public static final String CONFIG_URL = ".url";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    public static final String CLIENTIP = "client";
    private String _defaultDomain = null;
    private boolean _enabled = true;
    private String _appPrefix = null;
    private String _appID = null;
    private String _mySSOCookieName = null;
    private Cookie _ssoCookie = null;
    private String _sessionCookieName = null;
    private HashMap _verifySSOMap = null;

    public MessagingSSO(PropertyReader propertyReader) {
        this._enabled = propertyReader.getBooleanProperty("messagingsso.enable", "true");
        this._sessionCookieName = propertyReader.getStringProperty("messagingsso.sessioncookie", "JSESSIONID");
        this._appPrefix = propertyReader.getStringProperty("messagingsso.appprefix", "ssogrp1");
        this._appID = propertyReader.getStringProperty("messagingsso.appid", "iabs");
        this._mySSOCookieName = this._appPrefix + "-" + this._appID;
        String cookieDomain = propertyReader.getStringProperty("messagingsso.cookiedomain", "iplanet.com");
        String cookiePath = propertyReader.getStringProperty("messagingsso.cookiepath", "/");
        this._ssoCookie = new Cookie(this._mySSOCookieName, "");
        this._ssoCookie.setDomain(cookieDomain);
        this._ssoCookie.setPath(cookiePath);
        this._verifySSOMap = new HashMap();
        Enumeration enumeration = propertyReader.getKeyProperty(CONFIG_SSO_PREFIX, CONFIG_URL);
        while (enumeration.hasMoreElements()) {
            String appID = (String)enumeration.nextElement();
            String url = propertyReader.getStringProperty(CONFIG_SSO_PREFIX + appID + CONFIG_URL, "");
            String key = this._appPrefix + "-" + appID;
            if (url == null || url.length() <= 0) continue;
            Logging.trace(64, "Associating cookie " + key + " with verify URL " + url);
            this._verifySSOMap.put(key, url);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public Vector verifySSO(Cookie[] cookies, String clientIPAddress, boolean ignoreSelf) {
        if (!this._enabled) {
            return null;
        }
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        int nbCookies = cookies.length;
        Vector userCred = null;
        String cookieName = null;
        boolean isSelf = false;
        for (int i = 0; i < nbCookies; ++i) {
            String verifyurl;
            cookieName = cookies[i].getName();
            Logging.trace(64, "Got cookie:" + cookieName);
            isSelf = this._mySSOCookieName.equals(cookieName);
            if (isSelf && ignoreSelf || (verifyurl = (String)this._verifySSOMap.get(cookieName)) == null) continue;
            verifyurl = verifyurl + CLIENTIP + "=" + clientIPAddress;
            userCred = isSelf ? this.verifyOneSSO(verifyurl, this._sessionCookieName, cookies[i].getValue()) : this.verifyOneSSO(verifyurl, cookieName, cookies[i].getValue());
            if (userCred != null && userCred.size() >= 2 && this.isCredValid(userCred)) break;
        }
        return userCred;
    }

    public Cookie getSSOCookie(HttpSession session) {
        Cookie cookie = (Cookie)this._ssoCookie.clone();
        cookie.setValue(session.getId());
        return cookie;
    }

    public final void sendSuccess(ServletOutputStream output, String fquid, String authtype) throws IOException {
        output.println("fquid=" + fquid);
        output.println("authtype=" + authtype);
    }

    public final void relaySuccess(ServletOutputStream output, Vector userCred) throws IOException {
        for (int i = 0; i < userCred.size(); ++i) {
            output.println((String)userCred.elementAt(i));
        }
    }

    public final void sendError(ServletOutputStream output, String message) throws IOException {
        output.println("Error=" + message);
    }

    public final boolean hasSessionCookie(Cookie[] cookies) {
        int nbCookies = cookies.length;
        for (int i = 0; i < nbCookies; ++i) {
            if (!this._sessionCookieName.equals(cookies[i].getName())) continue;
            return true;
        }
        return false;
    }

    private Vector verifyOneSSO(String url, String cookieName, String cookieValue) {
        Vector<String> resp = new Vector<String>();
        Logging.trace(64, "Connecting to: " + url);
        try {
            URL ssoURL = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)ssoURL.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept-Language", "en");
            String headerCookie = cookieName + "=" + cookieValue;
            Logging.trace(64, "Cookie => " + headerCookie);
            conn.setRequestProperty("Cookie", headerCookie);
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String buf = null;
            Logging.trace(64, "Reading from: " + url);
            while ((buf = in.readLine()) != null) {
                resp.addElement(buf);
                Logging.trace(64, "Recvd: " + buf);
            }
            conn.disconnect();
        }
        catch (Exception e) {
            Logging.trace(64, "VerifySSO Exception: " + e.getMessage());
            return null;
        }
        if (resp.size() <= 0) {
            resp = null;
        }
        return resp;
    }

    private boolean isCredValid(Vector user) {
        boolean valid = true;
        if (user == null || user.size() < 2) {
            return false;
        }
        for (int i = 0; i < user.size(); ++i) {
            String stat = (String)user.elementAt(i);
            if (stat.toLowerCase().indexOf("error") == -1) continue;
            valid = false;
            break;
        }
        return valid;
    }
}

