/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.Domain;
import com.iplanet.xslui.auth.UserSession;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;

public class LDAPUserSession
implements UserSession {
    public static final String UID = "uid";
    public static final String PREFERREDLANGUAGE = "preferredLanguage";
    public static final String DEFAULTLANGUAGE = "en";
    private LDAPEntry _ldapEntry = null;
    private Domain _domain = null;
    private String _domainStr = null;
    private String _password = null;

    public LDAPUserSession(LDAPEntry ldapEntry, Domain domain) {
        this._ldapEntry = ldapEntry;
        this._domain = domain;
    }

    public LDAPUserSession(LDAPEntry ldapEntry, String domain) {
        this._ldapEntry = ldapEntry;
        this._domainStr = domain;
    }

    public LDAPUserSession(LDAPEntry ldapEntry) {
        this._ldapEntry = ldapEntry;
    }

    public String getUserId() {
        return this.getUserAttrib(UID);
    }

    public String getDomain() {
        if (this._domain != null) {
            return this._domain.getDomainName();
        }
        return this._domainStr;
    }

    public String getPreferredLanguage() {
        String lang = this.getUserAttrib(PREFERREDLANGUAGE);
        if (lang == null && this._domain != null) {
            lang = this._domain.getAttribute(PREFERREDLANGUAGE);
        }
        if (lang == null) {
            lang = DEFAULTLANGUAGE;
        }
        return lang;
    }

    public String getDN() {
        return this._ldapEntry.getDN();
    }

    public String getUserAttrib(String attribName) {
        if (attribName == null) {
            return null;
        }
        LDAPAttribute attr = this._ldapEntry.getAttribute(attribName);
        if (attr != null) {
            Enumeration values = attr.getStringValues();
            if (!values.hasMoreElements()) {
                return null;
            }
            return (String)values.nextElement();
        }
        return null;
    }

    public String[] getUserAttribs(String attribName) {
        if (attribName == null) {
            return null;
        }
        LDAPAttribute attr = this._ldapEntry.getAttribute(attribName);
        if (attr != null) {
            return attr.getStringValueArray();
        }
        return null;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getPassword() {
        return this._password;
    }
}

