/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.collections;

import com.sun.portal.rewriter.util.collections.ListSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ListMap
implements Map {
    public static final ListMap EMPTY_LISTMAP = new ListMap(Collections.EMPTY_MAP, ListSet.EMPTY_LISTSET, Collections.EMPTY_LIST);
    private final Map data;
    private final ListSet keyList;
    private final List valueList;

    public ListMap() {
        this.data = new HashMap();
        this.keyList = new ListSet();
        this.valueList = new ArrayList();
    }

    private ListMap(Map aMap, ListSet aKeyList, List aValueList) {
        this.data = aMap;
        this.keyList = aKeyList;
        this.valueList = aValueList;
    }

    public static ListMap unmodifiableListMap(ListMap aListMap) {
        return new ListMap(Collections.unmodifiableMap(aListMap.data), ListSet.unmodifiableListSet(aListMap.keyList), Collections.unmodifiableList(aListMap.valueList));
    }

    public void clear() {
        this.data.clear();
        this.keyList.clear();
        this.valueList.clear();
    }

    public Object matchesWith(Object aKey) {
        for (int i = 0; i < this.keyList.size(); ++i) {
            if (!this.keyList.get(i).toString().trim().equalsIgnoreCase(aKey.toString().trim())) continue;
            return this.keyList.get(i);
        }
        return null;
    }

    public Object get(Object aKey) {
        return this.data.get(aKey);
    }

    public Object put(Object aKey, Object aValue) {
        Object result = this.data.put(aKey, aValue);
        if (result != null) {
            this.keyList.remove(result);
            this.valueList.remove(aValue);
        }
        this.keyList.add(aKey);
        this.valueList.add(aValue);
        return result;
    }

    public void putAll(Map aMap) {
        Iterator iterator = aMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            this.put(key, aMap.get(key));
        }
    }

    public Set entrySet() {
        return this.data.entrySet();
    }

    public Object remove(Object aKey) {
        if (this.data.containsKey(aKey)) {
            Object value = this.data.get(aKey);
            this.keyList.remove(aKey);
            this.valueList.remove(value);
        }
        return this.data.remove(aKey);
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public boolean containsKey(Object aKey) {
        return this.data.containsKey(aKey);
    }

    public boolean containsValue(Object aKey) {
        return this.data.containsValue(aKey);
    }

    public Set keySet() {
        return this.keyList;
    }

    public Collection values() {
        return this.valueList;
    }

    public List keyList() {
        return this.keyList;
    }

    public List valueList() {
        return this.valueList;
    }

    public String toString() {
        return this.data.toString();
    }
}

