/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.xml.parser;

import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.TranslatorHelper;
import com.sun.portal.rewriter.engines.PageContent;
import com.sun.portal.rewriter.engines.xml.parser.StandardXMLReader;
import com.sun.portal.rewriter.engines.xml.parser.XMLParserListener;
import com.sun.portal.rewriter.engines.xml.parser.XMLReader;
import com.sun.portal.rewriter.rom.RuleSet;
import com.sun.portal.rewriter.rom.RuleSetHelper;
import com.sun.portal.rewriter.rom.common.Attribute;
import com.sun.portal.rewriter.rom.common.AttributeRule;
import com.sun.portal.rewriter.rom.common.TagText;
import com.sun.portal.rewriter.rom.common.TagTextRule;
import com.sun.portal.rewriter.util.collections.ListMap;
import com.sun.portal.rewriter.util.re.Pattern;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.Stack;

public class XMLReaderWrapper
implements XMLReader,
XMLParserListener {
    private int attStartOffset = -1;
    private int piStartOffset = -1;
    private final StringBuffer buffer = new StringBuffer();
    private final Stack elementStack = new Stack();
    private final Attribute attribute = new Attribute("");
    private final TagText tagText = new TagText("");
    private final Stack attributesStack = new Stack();
    private final String uri;
    private final XMLReader delegate;
    private final Translator translator;
    private final RuleSet ruleSet;
    private final PageContent pageContent;

    public XMLReaderWrapper(PageContent aPageContent, RuleSet aRuleSet, Translator aTranslator) {
        this.delegate = new StandardXMLReader(new StringReader(aPageContent.getOriginalContent()));
        this.ruleSet = aRuleSet;
        this.translator = aTranslator;
        this.uri = this.translator.getPageSpec().getPageURI().getFullFileURI();
        this.pageContent = aPageContent;
    }

    public void startElement(String key) {
        this.elementStack.push(key);
        this.attributesStack.push(ListMap.EMPTY_LISTMAP);
    }

    public void endElement() {
        this.elementStack.pop();
        this.attributesStack.pop();
    }

    public boolean startAttribute(String key) {
        this.attStartOffset = this.buffer.length();
        return true;
    }

    public int getOffset() {
        return this.buffer.length();
    }

    public void startPCData() {
    }

    public void endPCData(int startOffset) {
        String lTag = (String)this.elementStack.peek();
        this.tagText.recycleMatchee(lTag, (ListMap)this.attributesStack.peek(), this.uri);
        TagTextRule lTextMatch = (TagTextRule)RuleSetHelper.findXMLTagTextMatch(this.ruleSet, this.tagText);
        if (lTextMatch == null) {
            return;
        }
        String lPCData = this.buffer.substring(startOffset);
        this.buffer.delete(startOffset, this.buffer.length());
        String lResult = this.translator.translate(lPCData);
        this.buffer.append(lResult);
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void endParsing() {
        try {
            while (!this.delegate.atEOF()) {
                this.buffer.append(this.delegate.read());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected Exception : " + e.getMessage());
        }
        this.pageContent.getResultBuffer().append(this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAttribute(String key, String value) {
        try {
            String tag = (String)this.elementStack.peek();
            this.attribute.recycleMatchee(key, tag, "URL", this.uri);
            AttributeRule lMatch = (AttributeRule)RuleSetHelper.findXMLAttributeMatch(this.ruleSet, this.attribute);
            String lValue = this.buffer.substring(this.attStartOffset + 1, this.buffer.length() - 1);
            ListMap lAttributes = this.getAttributesListMap();
            lAttributes.put(key, lValue);
            if (lMatch == null) {
                return;
            }
            Pattern[] lList = lMatch.getParsedPatterns();
            String lResult = lList.length == 0 ? this.translator.translate(lValue) : TranslatorHelper.translateSubStrings(lList, lValue, this.translator);
            this.buffer.replace(this.attStartOffset + 1, this.buffer.length() - 1, lResult);
        }
        finally {
            this.attStartOffset = -1;
        }
    }

    private ListMap getAttributesListMap() {
        ListMap lAttributes = (ListMap)this.attributesStack.peek();
        if (!lAttributes.isEmpty()) {
            return lAttributes;
        }
        lAttributes = new ListMap();
        this.attributesStack.pop();
        this.attributesStack.push(lAttributes);
        return lAttributes;
    }

    public char read() throws IOException {
        char c = this.delegate.read();
        this.buffer.append(c);
        return c;
    }

    public boolean atEOFOfCurrentStream() throws IOException {
        return this.delegate.atEOFOfCurrentStream();
    }

    public boolean atEOF() throws IOException {
        return this.delegate.atEOF();
    }

    public void unread(char ch) throws IOException {
        this.buffer.deleteCharAt(this.buffer.length() - 1);
        this.delegate.unread(ch);
    }

    public int getLineNr() {
        return this.delegate.getLineNr();
    }

    public Reader openStream(String publicID, String systemID) throws MalformedURLException, FileNotFoundException, IOException {
        return this.delegate.openStream(publicID, systemID);
    }

    public void startNewStream(Reader reader) {
        this.delegate.startNewStream(reader);
    }

    public void startNewStream(Reader reader, boolean isInternalEntity) {
    }

    public void startPI() {
        this.piStartOffset = this.buffer.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endPI(String href) {
        if (href.startsWith("#")) {
            return;
        }
        try {
            this.attribute.recycleMatchee("href", "xml-stylesheet", "URL", this.uri);
            AttributeRule lMatch = (AttributeRule)RuleSetHelper.findXMLAttributeMatch(this.ruleSet, this.attribute);
            String lValue = this.buffer.substring(this.piStartOffset + 1, this.buffer.length() - 1);
            if (lMatch == null) {
                return;
            }
            Pattern[] lList = lMatch.getParsedPatterns();
            String lResult = lList.length == 0 ? this.translator.translate(lValue) : TranslatorHelper.translateSubStrings(lList, lValue, this.translator);
            this.buffer.replace(this.piStartOffset + 1, this.buffer.length() - 1, lResult);
        }
        finally {
            this.piStartOffset = -1;
        }
    }

    public int getStreamLevel() {
        return this.delegate.getStreamLevel();
    }

    public void setSystemID(String systemID) throws MalformedURLException {
        this.delegate.setSystemID(systemID);
    }

    public void setPublicID(String publicID) {
        this.delegate.setPublicID(publicID);
    }

    public String getSystemID() {
        return this.delegate.getSystemID();
    }
}

