/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.common;

import com.sun.portal.netlet.client.common.ClientConfig;
import com.sun.portal.netlet.client.common.ClientUtil;
import com.sun.portal.netlet.client.common.Connection;
import com.sun.portal.netlet.client.common.NetletSocketFactory;
import com.sun.portal.netlet.client.common.ProxyAuthDialog;
import com.sun.portal.netlet.client.common.ProxyAuthFailedException;
import com.sun.portal.netlet.client.common.ProxyAuthNeededException;
import com.sun.portal.netlet.client.common.ResourceProperties;
import com.sun.portal.netlet.econnection.Base64;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class ProxySConn
extends Connection
implements ActionListener {
    private DataInputStream in_b;
    private DataOutputStream out_b;
    private String dhost;
    private int dport;
    private ProxyAuthDialog pad;
    private String puser;
    private String ppass;

    public ProxySConn(int pp, String ph, boolean toClient) {
        super(pp, ph);
    }

    public ProxySConn(int pp, String ph, String cipherName) {
        super(pp, ph);
        NetletSocketFactory nsf = NetletSocketFactory.getNetletSocketFactory(ClientConfig.getDestProtocol(), ClientConfig.isJSSEEnabled(), ClientConfig.isPDCEnabled());
        this.conn = cipherName != null ? nsf.getSocket(this.conn, ph, pp, this.parseCipherList(cipherName)) : nsf.getSocket(this.conn, ph, pp, null);
    }

    public ProxySConn(int pp, String ph, int dp, String dh, String cipherName) throws ProxyAuthNeededException, ProxyAuthFailedException {
        this(pp, ph, dp, dh, false, cipherName);
    }

    public ProxySConn(int pp, String ph, int dp, String dh, boolean doauth, String cipherName) throws ProxyAuthNeededException, ProxyAuthFailedException {
        super(pp, ph);
        this.dhost = dh;
        this.dport = dp;
        if (this.conn != null) {
            try {
                this.in_b = new DataInputStream(this.conn.getInputStream());
                this.out_b = new DataOutputStream(this.conn.getOutputStream());
            }
            catch (IOException e) {
                System.out.println("ProxySConn setup IOE: " + e);
                try {
                    this.conn.close();
                }
                catch (IOException ie) {
                    // empty catch block
                }
                this.conn = null;
                return;
            }
            if (this.doProxyConnect(doauth) != 0) {
                try {
                    this.conn.close();
                }
                catch (IOException ie) {
                    // empty catch block
                }
                this.conn = null;
            }
            NetletSocketFactory nsf = NetletSocketFactory.getNetletSocketFactory(ClientConfig.getDestProtocol(), ClientConfig.isJSSEEnabled(), ClientConfig.isPDCEnabled());
            this.conn = cipherName != null ? nsf.getSocket(this.conn, dh, dp, this.parseCipherList(cipherName)) : nsf.getSocket(this.conn, dh, dp, null);
        }
    }

    public int doProxyConnect(boolean doauth) throws ProxyAuthNeededException, ProxyAuthFailedException {
        int rc = 0;
        String header = "CONNECT " + this.dhost + ":" + this.dport + " HTTP/1.0\r\n";
        try {
            if (doauth || ClientConfig.getProxyAuth()) {
                this.puser = ClientConfig.getProxyAuthUsername();
                this.ppass = ClientConfig.getProxyAuthPassword();
                if (this.puser == null || this.ppass == null) {
                    this.pad = new ProxyAuthDialog(new Frame(), this);
                    System.out.println("Netlet showing proxy authentication dialog");
                    this.pad.showWarning();
                    this.pad.waitForAction();
                }
                if (this.puser == null || this.ppass == null) {
                    throw new ProxyAuthFailedException(ResourceProperties.getString("psconn.1"));
                }
                header = header + "Proxy-Authorization: Basic " + Base64.encode(this.puser + ":" + this.ppass) + "\r\n\r\n";
            } else {
                header = header + "\r\n";
            }
            this.out_b.write(header.getBytes(), 0, header.length());
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in_b));
            String line = "";
            while ((line = br.readLine()) != null && line.length() >= 3) {
                if (!line.startsWith("HTTP/1")) continue;
                int s = line.indexOf(" ");
                String num = line.substring(s + 1);
                if (num.startsWith("407")) {
                    throw new ProxyAuthNeededException("Proxy Authentication Required");
                }
                if (!num.startsWith("401")) continue;
                throw new ProxyAuthFailedException(ResourceProperties.getString("psconn.3"));
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println("ProxySConn SIOBE connecting to proxy: " + e);
            rc = -1;
        }
        catch (IOException e) {
            System.out.println("ProxySConn IOE connecting to proxy: " + e);
            rc = -1;
        }
        return rc;
    }

    public void actionPerformed(ActionEvent evt) {
        if (!"cancel".equals(evt.getActionCommand())) {
            this.puser = ClientUtil.rfc1522(this.pad.getUsername());
            this.ppass = ClientUtil.rfc1522(this.pad.getPassword());
            ClientConfig.setProxyAuthUsername(this.puser);
            ClientConfig.setProxyAuthPassword(this.ppass);
        }
        this.pad.notifyAction();
        this.pad.setVisible(false);
        this.pad.dispose();
    }

    private String[] parseCipherList(String cipherList) {
        StringTokenizer stz = new StringTokenizer(cipherList, "|");
        String[] cipherArray = new String[stz.countTokens()];
        int i = 0;
        while (stz.hasMoreElements()) {
            cipherArray[i] = stz.nextElement().toString();
        }
        return cipherArray;
    }
}

