/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.yahoo;

import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.collections.ListMap;
import com.sun.portal.rewriter.util.uri.DecoratedURI;
import com.sun.portal.rproxy.rewriter.SRAPTranslatorHelper;
import com.sun.portal.rproxy.rewriter.util.uri.SRAPGatewayURI;
import com.sun.portal.rproxy.rewriter.yahoo.QueryParser;
import com.sun.portal.rproxy.rewriter.yahoo.YahooConfigManager;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import sun.misc.BASE64Encoder;

public final class YahooTranslatorHelper {
    private static final String YPB_URL = "ypburl";
    private static final String MD5_SIGN = "sign";
    private static final String DOT_DONE = ".done";

    public static String doTranslate(SRAPGatewayURI aGatewayURI, DecoratedURI aYahooURI) {
        String lAbsoluteURIString = aYahooURI.toExternalForm();
        String bQuery = StringHelper.normalize((String)aYahooURI.getDecoratee().getQuery());
        String translatedQuery = YahooTranslatorHelper.translateQuery(bQuery, aGatewayURI);
        if (translatedQuery == bQuery) {
            return lAbsoluteURIString;
        }
        lAbsoluteURIString = aYahooURI.getFullFileURI() + "?" + translatedQuery + aYahooURI.getReference();
        return lAbsoluteURIString;
    }

    private static String translateQuery(String aQuery, SRAPGatewayURI aGatewayURI) {
        try {
            ListMap bParamMap = null;
            String urlKey = YPB_URL;
            if (YahooTranslatorHelper.isYahooAuthURL(aQuery)) {
                bParamMap = YahooTranslatorHelper.rewriteParam(urlKey, aQuery, aGatewayURI);
                String newMD5 = YahooTranslatorHelper.computeYahooSign((Map)bParamMap);
                bParamMap.put((Object)urlKey, (Object)URLEncoder.encode(bParamMap.get((Object)urlKey).toString()));
                bParamMap.put((Object)MD5_SIGN, (Object)newMD5);
            } else if (YahooTranslatorHelper.isYahooLogoutURL(aQuery)) {
                bParamMap = YahooTranslatorHelper.rewriteParam(urlKey, aQuery, aGatewayURI);
            } else if (YahooTranslatorHelper.isYahooEditURL(aQuery)) {
                urlKey = DOT_DONE;
                bParamMap = YahooTranslatorHelper.rewriteParam(urlKey, aQuery, aGatewayURI);
            } else {
                return aQuery;
            }
            return YahooTranslatorHelper.toQueryForm(bParamMap);
        }
        catch (MalformedURLException e) {
            return aQuery;
        }
    }

    private static String toQueryForm(ListMap aParamMap) {
        List lKeys = aParamMap.keyList();
        StringBuffer lResult = new StringBuffer();
        for (int i = 0; i < lKeys.size(); ++i) {
            String bKey = lKeys.get(i).toString();
            String bValue = aParamMap.get((Object)bKey).toString();
            if (i != 0) {
                lResult.append("&");
            }
            if (bValue == null) {
                lResult.append(bKey).append("=");
                continue;
            }
            lResult.append(bKey).append("=").append(bValue);
        }
        return lResult.toString();
    }

    private static boolean isYahooEditURL(String url) {
        return url.indexOf(DOT_DONE) != -1;
    }

    private static boolean isYahooLogoutURL(String url) {
        return url.indexOf(YPB_URL) != -1;
    }

    private static boolean isYahooAuthURL(String url) {
        return url.indexOf("&ypburl") != -1 && url.indexOf("&sign") != -1;
    }

    private static String computeYahooSign(Map aParamMap) {
        String[] args = new String[]{YahooConfigManager.getCorporateID(), aParamMap.get("login").toString(), aParamMap.get("usernum").toString(), aParamMap.get(YPB_URL).toString(), aParamMap.get("ma").toString(), YahooConfigManager.getCorporatePassword()};
        try {
            MessageDigest bMessageDigest = MessageDigest.getInstance("MD5");
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                bMessageDigest.update(args[i].getBytes());
            }
            StringBuffer bSignBuffer = new StringBuffer(new BASE64Encoder().encodeBuffer(bMessageDigest.digest()));
            bSignBuffer = new StringBuffer(bSignBuffer.substring(0, 24));
            int length = bSignBuffer.length();
            block8: for (int i = 0; i < length; ++i) {
                switch (bSignBuffer.charAt(i)) {
                    case '+': {
                        bSignBuffer.setCharAt(i, '.');
                        continue block8;
                    }
                    case '/': {
                        bSignBuffer.setCharAt(i, '_');
                        continue block8;
                    }
                    case '=': {
                        bSignBuffer.setCharAt(i, '-');
                        continue block8;
                    }
                }
            }
            return bSignBuffer.toString();
        }
        catch (NoSuchAlgorithmException e) {
            Debug.error((String)"MD5 Algorithm Not Found", (Throwable)e);
            return "MD5AlgorithmNotFound";
        }
    }

    private static ListMap rewriteParam(String aParamName, String aQuery, SRAPGatewayURI aGatewayURI) throws MalformedURLException {
        ListMap lParamMap = QueryParser.parseQueryString(aQuery);
        String paramvalue = lParamMap.get((Object)aParamName).toString();
        DecoratedURI lURI = new DecoratedURI(URLDecoder.decode(paramvalue));
        String lModifiedURI = SRAPTranslatorHelper.prefixGateway(aGatewayURI, lURI);
        lParamMap.put((Object)aParamName, (Object)lModifiedURI);
        return lParamMap;
    }
}

