/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.server;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.ServiceHandler;
import com.sun.portal.rproxy.configservlet.server.UserProfileCache;
import java.rmi.RemoteException;
import java.util.Map;

public class UserAttributesServiceHandler
implements ServiceHandler {
    public Response handleRequest(Request request) throws RemoteException {
        String tokid = request.getSSOTokenId();
        Response resp = UserProfileCache.getResponse(tokid);
        boolean valid = true;
        resp.setRequestType(request.getRequestType());
        resp.setServiceName(request.getServiceName());
        resp.setNormal(valid);
        return resp;
    }

    protected Response fetchUserAttributes(Request request, SSOToken token) throws RemoteException {
        try {
            AMStoreConnection connection = new AMStoreConnection(token);
            AMUser user = connection.getUser(token.getPrincipal().getName());
            Map attrs = user.getAttributes();
            Response response = new Response(request.getServiceName(), request.getRequestType(), attrs);
            return response;
        }
        catch (SSOException ssoe) {
            throw new RemoteException("Not able to get Global Attributes", ssoe);
        }
        catch (AMException dpe) {
            throw new RemoteException("Not able to get Global Attributes", dpe);
        }
    }

    protected SSOToken getSSOToken(Request request) throws RemoteException {
        try {
            String tokenId = request.getSSOTokenId();
            SSOTokenManager tokenManager = SSOTokenManager.getInstance();
            return tokenManager.createSSOToken(tokenId);
        }
        catch (SSOException ssoe) {
            throw new RemoteException("Not able to get the token", ssoe);
        }
    }
}

