/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttributeExtractor {
    public static String getString(Map source, String name, String defaultValue) {
        Set set = (Set)source.get(name);
        if (null == set) {
            return defaultValue;
        }
        Iterator it = set.iterator();
        return it.hasNext() ? (String)it.next() : defaultValue;
    }

    public static String getLowerCaseString(Map source, String name, String defaultValue) {
        Set set = (Set)source.get(name);
        if (null == set) {
            return defaultValue;
        }
        Iterator it = set.iterator();
        return it.hasNext() ? it.next().toString().toLowerCase() : defaultValue;
    }

    public static int getInt(Map source, String name, int defaultValue) {
        Set set = (Set)source.get(name);
        if (null == set) {
            return defaultValue;
        }
        Iterator it = set.iterator();
        return it.hasNext() ? Integer.parseInt((String)it.next()) : defaultValue;
    }

    public static boolean getBoolean(Map source, String name, boolean defaultValue) {
        Set set;
        Iterator it1;
        Object val = source.get(name);
        if (val != null && (it1 = ((Set)val).iterator()).hasNext()) {
            Object obj = it1.next();
        }
        if (null == (set = (Set)source.get(name))) {
            return defaultValue;
        }
        Iterator it = set.iterator();
        return it.hasNext() ? new Boolean((String)it.next()) : defaultValue;
    }

    public static List getStringList(Map source, String name) {
        Set set = (Set)source.get(name);
        if (null == set) {
            return new ArrayList();
        }
        ArrayList<String> ret = new ArrayList<String>(set.size());
        Iterator it = set.iterator();
        while (it.hasNext()) {
            ret.add((String)it.next());
        }
        return ret;
    }

    public static List getLowerCaseStringList(Map source, String name) {
        Set set = (Set)source.get(name);
        if (null == set) {
            return new ArrayList();
        }
        ArrayList<String> ret = new ArrayList<String>(set.size());
        Iterator it = set.iterator();
        while (it.hasNext()) {
            ret.add(it.next().toString().toLowerCase());
        }
        return ret;
    }

    public static List getLowerCaseURLList(Map source, String name) {
        Set set = (Set)source.get(name);
        if (null == set) {
            return new ArrayList();
        }
        URL rawURL = null;
        int port = -1;
        String element = null;
        ArrayList<String> ret = new ArrayList<String>(set.size());
        String lowerCaseElement = null;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            element = it.next().toString();
            lowerCaseElement = element.toLowerCase();
            if (lowerCaseElement.startsWith("http")) {
                try {
                    rawURL = new URL(element);
                    port = rawURL.getPort();
                    if (port == -1) {
                        port = lowerCaseElement.startsWith("https") ? 443 : 80;
                    }
                    ret.add(rawURL.getProtocol().toLowerCase() + "://" + rawURL.getHost().toLowerCase() + ":" + port + rawURL.getPath());
                }
                catch (MalformedURLException mae) {}
                continue;
            }
            ret.add(element);
        }
        return ret;
    }
}

