/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.impl;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.sun.addressbook.ABSession;
import com.sun.addressbook.ABStore;
import com.sun.addressbook.ABStoreException;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.ValidationException;
import java.util.Properties;

public class WabpSSOAdapter
extends SSOAdapter {
    protected ABStore abStore = null;
    protected ABSession abSession = null;
    protected static String WABP_SERVICE_CLASS = "com.sun.addressbook.wabp.WabpABStore";
    protected static String WABP_CONTEXT_URI = "wabp";
    protected static String WABP_LOGIN_CMD = "login.wabp";
    protected static String WABP_USER_NAME = "username";
    protected static String WABP_USER_PASSWORD = "password";
    protected static final String CLIENT_DEFAULT_PORT = "80";
    protected static final String CLIENT_DEFAULT_PROTOCOL = "http";

    public void init(String adapterName, SSOToken token, Properties adapterProperties) throws SSOAdapterException {
        super.init(adapterName, token, adapterProperties);
        if (adapterProperties.getProperty("validate", "false").equals("true")) {
            try {
                this.validate();
            }
            catch (ValidationException ve) {
                throw new SSOAdapterException(ve.getLocalizedMessage("ssoadapter", this.locale), true);
            }
        }
    }

    public void validate() throws ValidationException {
    }

    public Object getConnection() {
        ABStore obj = null;
        try {
            obj = this.getABStore();
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to get connection. ", e);
        }
        if (obj != null) {
            SSOAdapterDebug.logMessage(this.identifier + " connected to store");
        }
        return obj;
    }

    public ABStore getABStore() throws Exception {
        if (this.isAvailable()) {
            return this.abStore;
        }
        this.abSession = this.getABSession();
        this.abStore = this.abSession.getABStore(WABP_SERVICE_CLASS);
        this.abStore.connect();
        return this.abStore;
    }

    public ABSession getABSession() throws Exception {
        if (this.abSession != null) {
            return this.abSession;
        }
        Properties props = new Properties();
        String host = this.adapterProperties.getProperty("host");
        String defport = this.adapterProperties.getProperty("port", CLIENT_DEFAULT_PORT);
        String port = this.adapterProperties.getProperty("clientPort", defport);
        String protocol = this.adapterProperties.getProperty("protocol", CLIENT_DEFAULT_PROTOCOL);
        String contexturi = this.adapterProperties.getProperty("uwcContext");
        String domain = this.adapterProperties.getProperty("domain");
        String enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth", "false");
        String uid = null;
        String password = null;
        if (domain != null && domain.length() > 0) {
            uid = uid + "@" + domain;
        }
        if (host != null) {
            props.put("ab.host", host);
        }
        if (port != null) {
            props.put("ab.port", port);
        }
        if (protocol != null) {
            props.put("ab.protocol", protocol);
        }
        if (contexturi != null) {
            props.put("ab.contextURI", contexturi);
        }
        if (enableProxyAuth != null) {
            props.put("ab.enableProxyAuth", enableProxyAuth);
            if (enableProxyAuth.equalsIgnoreCase("true")) {
                SSOToken tok = this.getSSOToken();
                AMStoreConnection amsc = null;
                AMUser auser = null;
                String usrAttr = null;
                if (tok != null) {
                    usrAttr = this.adapterProperties.getProperty("userAttribute", "uid");
                    try {
                        amsc = new AMStoreConnection(tok);
                        auser = amsc.getUser(tok.getPrincipal().getName());
                        uid = auser.getStringAttribute(usrAttr);
                        if (uid != null) {
                            props.put("ab.userName", uid);
                        }
                    }
                    catch (SSOException ssoe) {
                        SSOAdapterDebug.logError(this.identifier + "proxy uid retrieval failed ", ssoe);
                    }
                    catch (AMException ame) {
                        SSOAdapterDebug.logError(this.identifier + "proxy uid retrieval failed ", ame);
                    }
                    SSOAdapterDebug.logMessage(this.identifier + "connecting with proxy uid=" + uid);
                }
                String proxyAdminUid = this.adapterProperties.getProperty("proxyAdminUid");
                String proxyAdminPassword = this.adapterProperties.getProperty("proxyAdminPassword");
                if (proxyAdminUid != null) {
                    props.put("ab.proxyAdminUid", proxyAdminUid);
                }
                if (proxyAdminPassword != null) {
                    props.put("ab.proxyAdminPassword", proxyAdminPassword);
                }
            } else {
                uid = this.adapterProperties.getProperty("uid");
                if (uid != null) {
                    props.put("ab.userName", uid);
                }
                if ((password = this.adapterProperties.getProperty("password")) != null) {
                    props.put("ab.userPassword", password);
                }
            }
        }
        this.abSession = ABSession.getInstance((Properties)props);
        return this.abSession;
    }

    public boolean isAvailable() {
        try {
            return this.abStore != null && this.abStore.isConnected();
        }
        catch (ABStoreException abse) {
            SSOAdapterDebug.logMessage("WabpSSOAdapter.isAvailable(): Failed to check is ABStore connected");
            return false;
        }
    }

    public boolean closeConnection() {
        boolean retval = true;
        try {
            this.abStore.disconnect();
            this.abStore = null;
            this.abSession = null;
        }
        catch (Exception e) {
            retval = false;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
        return retval;
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            if (this.abStore != null) {
                this.abStore.disconnect();
            }
            this.abStore = null;
            this.abSession = null;
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to close connection " + "to store ", e);
            return;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
    }
}

