/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.containers;

import com.sun.portal.desktop.DesktopRequestThreadLocalizer;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.ContainerProvider;
import com.sun.portal.providers.containers.UnsupportedWindowStateException;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.jsp.JSPProvider;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSPContainerProviderAdapter
extends JSPProvider
implements ContainerProvider {
    public ContainerProviderContext getContainerProviderContext() throws ProviderException {
        ProviderContext pc = this.getProviderContext();
        if (!(pc instanceof ContainerProviderContext)) {
            throw new ProviderException("JSPContainerProviderAdapter.getContainerProviderContext(): not a container provider context");
        }
        return (ContainerProviderContext)pc;
    }

    public List getSelectedChannels() throws ProviderException {
        try {
            return this.getContainerProviderContext().getSelectedChannels(this.getName());
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("JSPContainerProviderAdapter.getSelectedChannels()", pce);
        }
    }

    public List getAvailableChannels() throws ProviderException {
        try {
            return this.getContainerProviderContext().getAvailableChannels(this.getName());
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("JSPContainerProviderAdapter.getAvailableChannels()", pce);
        }
    }

    public List getAvailableAndUserDefinedChannels() throws ProviderException {
        try {
            List availableChannels = this.getAvailableChannels();
            Map userDefinedChannels = this.getProviderContext().getCollectionProperty(this.getName(), "userDefinedChannels");
            availableChannels.removeAll(userDefinedChannels.values());
            Iterator itr = userDefinedChannels.keySet().iterator();
            while (itr.hasNext()) {
                availableChannels.add((String)itr.next());
            }
            return availableChannels;
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("JSPContainerProviderAdapter.getAvailableAndUserDefinedChannels()", pce);
        }
    }

    public void setSelectedChannels(List sel) throws ProviderException {
        try {
            this.getContainerProviderContext().setSelectedChannels(this.getName(), sel);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("JSPContainerProviderAdapter.setSelectedChannels()", pce);
        }
    }

    public void setAvailableChannels(List avail) throws ProviderException {
        try {
            this.getContainerProviderContext().setAvailableChannels(this.getName(), avail);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("JSPContainerProviderAdapter.setAvailableChannels()", pce);
        }
    }

    public long getRefreshTime() throws ProviderException {
        String refreshTime = this.getStringProperty("refreshTime");
        long refreshTimelong = 0L;
        if (refreshTime != null && refreshTime.length() != 0) {
            return Long.parseLong(refreshTime);
        }
        List selected = this.getSelectedChannels();
        int size = selected.size();
        for (int i = 0; i < size; ++i) {
            String channel = (String)selected.get(i);
            Provider p = this.getContainerProviderContext().getProvider(DesktopRequestThreadLocalizer.getRequest(), this.getName(), channel);
            if (p != null) {
                try {
                    long rt = p.getRefreshTime();
                    refreshTimelong = Math.min(refreshTimelong, rt);
                }
                catch (ProviderException pe) {
                    this.getProviderContext().debugError("ContainerProviderAdapter.getRefreshTime(): exception in getRefreshTime " + channel);
                }
                continue;
            }
            this.getProviderContext().debugError("ContainerProviderAdapter.getRefreshTime(): invalid channel " + channel);
        }
        return refreshTimelong;
    }

    public int getWindowState(String channelName) throws ProviderException {
        return -1;
    }

    public void setWindowState(String channelName, int windowState) throws UnsupportedWindowStateException {
        throw new UnsupportedWindowStateException("Setting a window state is not supported in the default impl of containerprovider");
    }

    public int[] getSupportedWindowStates() throws ProviderException {
        int[] winstates = new int[]{-1};
        return winstates;
    }
}

