/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.encode;

import com.sun.portal.desktop.encode.EncoderError;
import com.sun.portal.desktop.encode.EncoderException;
import com.sun.portal.desktop.encode.TypeEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Encoder {
    private static Map encoders = Collections.synchronizedMap(new HashMap());
    public static TypeEncoder XML_ENCODER = null;
    public static TypeEncoder HTML_ENCODER = null;
    public static TypeEncoder FORMNAME_ENCODER = null;
    public static TypeEncoder COOKIE_ENCODER = null;

    private Encoder() {
    }

    public static TypeEncoder get(String encoderClassName) throws EncoderException {
        TypeEncoder encoder = (TypeEncoder)encoders.get(encoderClassName);
        if (encoder == null) {
            try {
                encoder = (TypeEncoder)Class.forName(encoderClassName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new EncoderException("Encoder.encode()", cnfe);
            }
            catch (InstantiationException ie) {
                throw new EncoderException("Encoder.encode()", ie);
            }
            catch (IllegalAccessException iae) {
                throw new EncoderException("Encoder.encode()", iae);
            }
            encoders.put(encoderClassName, encoder);
        }
        return encoder;
    }

    public static String encode(String encoderClassName, String text) throws EncoderException {
        TypeEncoder encoder = Encoder.get(encoderClassName);
        return encoder.encode(text);
    }

    static {
        try {
            XML_ENCODER = Encoder.get("com.sun.portal.desktop.encode.XMLEncoder");
            HTML_ENCODER = Encoder.get("com.sun.portal.desktop.encode.HTMLEncoder");
            FORMNAME_ENCODER = Encoder.get("com.sun.portal.desktop.encode.FormNameEncoder");
            COOKIE_ENCODER = Encoder.get("com.sun.portal.desktop.encode.CookieEncoderDecoder");
        }
        catch (EncoderException ee) {
            throw new EncoderError("Encoder.<init>: error initializing standard encoder types", ee);
        }
    }
}

