/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.pool;

import com.sun.common.pool.ObjectManager;
import com.sun.common.pool.PartitionObject;
import com.sun.common.pool.Pool;
import com.sun.common.pool.SimpleObjectPool;

public class ParallelObjectPool
implements Pool {
    private int _minSize;
    private int _maxSize;
    private int _partitions;
    private Pool[] _pools;
    private boolean _destroyed;
    private int[] _partitionUse;
    private static int _pnum = 0;

    public ParallelObjectPool(ObjectManager objectManager, int minSize, int maxSize, boolean overflow, int partitions) {
        if (partitions < 1) {
            throw new IllegalArgumentException("ParallelObjectPool.<init>: partitions<1");
        }
        this._minSize = minSize;
        this._maxSize = maxSize;
        this._partitions = partitions;
        this._pools = new Pool[partitions];
        int partitionMinSize = minSize / partitions;
        int partitionMaxSize = maxSize / partitions;
        int partitionMinRest = minSize % partitions;
        int partitionMaxRest = maxSize % partitions;
        int min = partitionMinSize + (partitionMinRest-- > 0 ? 1 : 0);
        int max = partitionMaxSize + (partitionMaxRest-- > 0 ? 1 : 0);
        for (int i = 0; i < partitions; ++i) {
            this._pools[i] = new SimpleObjectPool(objectManager, min, max, overflow);
            min = partitionMinSize + (partitionMinRest-- > 0 ? 1 : 0);
            max = partitionMaxSize + (partitionMaxRest-- > 0 ? 1 : 0);
        }
        this._partitionUse = new int[partitions];
    }

    private synchronized int calculatePartition() {
        return _pnum++ % this._partitions;
    }

    public Object obtainObject(Object param) {
        if (this._destroyed) {
            throw new IllegalStateException();
        }
        int partition = this.calculatePartition();
        Pool pool = this._pools[partition];
        Object o = pool.obtainObject(param);
        if (o == null) {
            for (int i = 0; o == null && i < this._partitions; ++i) {
                if (i == partition || (o = (pool = this._pools[i]).obtainObject(param)) == null) continue;
                partition = i;
            }
        }
        if (o != null && o instanceof PartitionObject) {
            ((PartitionObject)o).setPartition(partition);
            int n = partition;
            this._partitionUse[n] = this._partitionUse[n] + 1;
        }
        return o;
    }

    public void releaseObject(Object o) {
        int partition = o instanceof PartitionObject ? ((PartitionObject)o).getPartition() : this.calculatePartition();
        this._pools[partition].releaseObject(o);
    }

    public int getLeased() {
        int leased = 0;
        for (int i = 0; i < this._pools.length; ++i) {
            leased += this._pools[i].getLeased();
        }
        return leased;
    }

    public int getMinSize() {
        return this._minSize;
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public int[] getPartitionUse() {
        return (int[])this._partitionUse.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int maxSize) {
        ParallelObjectPool parallelObjectPool = this;
        synchronized (parallelObjectPool) {
            if (this._destroyed) {
                throw new IllegalStateException();
            }
            int partitionMaxSize = maxSize / this._partitions;
            int partitionMaxRest = maxSize % this._partitions;
            int max = partitionMaxSize + (partitionMaxRest-- > 0 ? 1 : 0);
            for (int i = 0; i < this._partitions; ++i) {
                this._pools[i].setMaxSize(max);
                max = partitionMaxSize + (partitionMaxRest-- > 0 ? 1 : 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ParallelObjectPool parallelObjectPool = this;
        synchronized (parallelObjectPool) {
            if (this._destroyed) {
                throw new IllegalStateException();
            }
            this._destroyed = true;
            for (int i = 0; i < this._partitions; ++i) {
                this._pools[i].destroy();
            }
        }
    }

    public final boolean doesReuseObjects() {
        return true;
    }

    protected void finalize() {
        if (!this._destroyed) {
            this.destroy();
        }
    }
}

