/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.cal;

import com.sun.comclient.calendar.DateTime;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.cal.DateCommandTag;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.jsp.JspException;

public class DateFormatTag
extends DateCommandTag {
    private String parse;

    public void setParse(String parse) {
        this.parse = this.evalAttribute(parse);
    }

    public boolean execute() throws JspException {
        DateTime datetime = this.findDateTime();
        if (datetime == null) {
            throw new JspException("DateFormatTag: no DateTime found or specified");
        }
        if (this.getFormat() == null) {
            throw new JspException("DateFormatTag: format attribute must be specified");
        }
        SimpleDateFormat formatter = new SimpleDateFormat(this.getFormat());
        formatter.setCalendar((Calendar)datetime);
        formatter.setLenient(false);
        formatter.setTimeZone(datetime.getTimeZone());
        try {
            if (this.parse == null) {
                Date date = datetime.getTime();
                String value = formatter.format(date);
                this.pageContext.getOut().print(value);
            } else {
                Date date = formatter.parse(this.parse);
                datetime.setTime(date);
            }
        }
        catch (ParseException e) {
            this.getContext().setErrorCode("CAL_001");
            Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".execute(): " + "DateFormatTag: Error Code CAL_001 - Couldnt parse - " + this.parse), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            throw new JspException("IO Exception: " + e.getMessage());
        }
        return true;
    }

    public void release() {
        super.release();
        this.parse = null;
    }
}

