/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netmail.protocol;

import com.sun.portal.netmail.protocol.Address;
import com.sun.portal.netmail.protocol.PersonalAddressBook;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class AddressList
implements Cloneable,
Serializable {
    int maxSize = 1024;
    public Vector addresses = new Vector();

    public AddressList() {
    }

    public AddressList(int n) {
        this.maxSize = n;
    }

    public Object clone() throws CloneNotSupportedException {
        AddressList addressList = (AddressList)super.clone();
        addressList.addresses = new Vector(this.addresses.size());
        Enumeration enumeration = this.addresses.elements();
        while (enumeration.hasMoreElements()) {
            Address address = (Address)enumeration.nextElement();
            addressList.addresses.addElement(address.clone());
        }
        return addressList;
    }

    public int size() {
        return this.addresses.size();
    }

    public boolean containsAddress(Address address) {
        return this.addresses.indexOf(address, 0) != -1;
    }

    public boolean removeAddress(String string) {
        Enumeration enumeration = this.addresses.elements();
        while (enumeration.hasMoreElements()) {
            Address address = (Address)enumeration.nextElement();
            if (!string.endsWith(address.getAddress())) continue;
            this.addresses.removeElement(address);
            return true;
        }
        return false;
    }

    public boolean removeAddress(Address address) {
        if (address == null) {
            return false;
        }
        int n = this.addresses.indexOf(address, 0);
        if (n != -1) {
            this.addresses.removeElementAt(n);
            return true;
        }
        return false;
    }

    public void addAddresses(String string, PersonalAddressBook personalAddressBook) throws IllegalArgumentException {
        this.addAddressesRec(string, new Vector(), personalAddressBook);
    }

    public void addAddressesRec(String string, Vector vector, PersonalAddressBook personalAddressBook) throws IllegalArgumentException {
        Address[] addressArray = Address.parse(string);
        for (int i = 0; i < addressArray.length; ++i) {
            if (addressArray[i].getComment().length() == 0 && personalAddressBook != null) {
                if (vector.contains(addressArray[i].getEmail())) continue;
                String string2 = personalAddressBook.expandNickname(addressArray[i].getEmail());
                if (string2 == null) {
                    this.addAddress(addressArray[i]);
                    continue;
                }
                vector.addElement(addressArray[i].getEmail());
                this.addAddressesRec(string2, vector, personalAddressBook);
                continue;
            }
            this.addAddress(addressArray[i]);
        }
    }

    public void addAddress(Address address) {
        if (this.containsAddress(address)) {
            return;
        }
        if (this.addresses.size() >= this.maxSize) {
            this.addresses.removeElementAt(this.addresses.size() - 1);
        }
        this.addresses.addElement(address);
    }

    public String formattedList() {
        return this.formattedList(false, false);
    }

    public String formattedList(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        String string = "";
        Enumeration enumeration = this.addresses.elements();
        while (enumeration.hasMoreElements()) {
            Address address = (Address)enumeration.nextElement();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
                n += 2;
            }
            string = address.getAddress(bl);
            if (bl2 && n >= 8 && n + string.length() > 80) {
                stringBuffer.append("\n\t");
                n = 8;
            }
            stringBuffer.append(string);
            n += string.length();
        }
        return stringBuffer.toString();
    }
}

