/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.eproxy.ProxyInfo;
import com.sun.portal.netlet.eproxy.SConn;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import java.net.Socket;

public class NetletRequestRouter {
    public static final boolean useProxyTunnel = GatewayProfile.getBoolean("NetletProxyTunnel", false);
    public static final String NETLET_PROTOCOL_FOR_PROXY_TUNNEL = "https";
    private static final int HTTP_PROXY_PORT = 8080;
    private int clientPort = -1;

    public NetletRequestRouter(int clientPort) {
        this.clientPort = clientPort;
    }

    public Socket getConnection(String host, int port) {
        if (!useProxyTunnel) {
            return this.directConnection(host, port);
        }
        return this.tunnelConnection(host, port);
    }

    private Socket directConnection(String host, int port) {
        return this.directSSLConnection(host, port);
    }

    private Socket tunnelConnection(String host, int port) {
        return this.tunnelSSLConnection(host, port);
    }

    private Socket directSSLConnection(String host, int port) {
        return SConn.sslconnect(port, host);
    }

    private Socket tunnelSSLConnection(String host, int port) {
        String proxy = ProxyInfo.getWebProxy(NETLET_PROTOCOL_FOR_PROXY_TUNNEL, host);
        String proxyHost = null;
        int proxyPort = -1;
        if (proxy == null) {
            return this.directSSLConnection(host, port);
        }
        if (proxy.indexOf(":") != -1) {
            proxyHost = proxy.substring(0, proxy.indexOf(58));
            proxyPort = Integer.parseInt(proxy.substring(proxy.indexOf(58) + 1));
        } else {
            proxyHost = proxy;
            proxyPort = 8080;
        }
        return SConn.sslProxyConnect(host, port, proxyHost, proxyPort, this.clientPort);
    }
}

