/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.connectionhandler.RWGroupJSSProxy;
import com.sun.portal.util.DomainWebProxyConfig;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.ServiceReachabilityInfo;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import sun.net.www.protocol.http.HttpURLConnection;

public class JSSProxyRunnable
implements Runnable {
    public static HashMap connectHashMap = new HashMap();
    private ServerSocket sconnection = null;

    public JSSProxyRunnable(ServerSocket ss) {
        this.sconnection = ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean go = true;
        boolean isHTTPS = this.sconnection instanceof SSLServerSocket;
        while (go) {
            try {
                Socket inconnection;
                block34: {
                    try {
                        inconnection = this.sconnection.accept();
                        if (!PerfContextObject.ENABLE_PERF) break block34;
                        if (isHTTPS) {
                            SocketCount.incrementSSLSockets();
                        } else {
                            SocketCount.incrementPlainSockets();
                        }
                    }
                    catch (IOException e) {
                        if (GWDebug.debug.errorEnabled()) {
                            GWDebug.debug.error("JSSProxyRunnable: Unable to accept new connection." + e);
                        }
                        if (this.sconnection != null) {
                            try {
                                this.sconnection.close();
                                if (PerfContextObject.ENABLE_PERF) {
                                    SocketCount.decrementServerSockets();
                                }
                            }
                            catch (IOException ee) {
                                if (GWDebug.debug.errorEnabled()) {
                                    GWDebug.debug.error("JSSProxyRunnable: Unable to close server socket." + e);
                                }
                            }
                            finally {
                                this.sconnection = null;
                            }
                        }
                        go = false;
                        continue;
                    }
                }
                try {
                    inconnection.setTcpNoDelay(true);
                }
                catch (SocketException e) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("JSSProxyRunnable: Unable to  TcpNoDelay." + e);
                    }
                    if (inconnection == null) continue;
                    try {
                        inconnection.close();
                        if (!PerfContextObject.ENABLE_PERF) continue;
                        if (isHTTPS) {
                            SocketCount.decrementSSLSockets();
                            continue;
                        }
                        SocketCount.decrementPlainSockets();
                    }
                    catch (IOException ee) {}
                    continue;
                    finally {
                        inconnection = null;
                        continue;
                    }
                }
                JSSProxySessionRunnable p = new JSSProxySessionRunnable(inconnection);
                try {
                    GWThreadPool.run(p);
                }
                catch (InterruptedException e) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("JSSProxyRunnable: Unable to run new JSSProxySession", e);
                    }
                    if (inconnection == null) continue;
                    try {
                        inconnection.close();
                        if (!PerfContextObject.ENABLE_PERF) continue;
                        if (isHTTPS) {
                            SocketCount.decrementSSLSockets();
                            continue;
                        }
                        SocketCount.decrementPlainSockets();
                    }
                    catch (IOException ee) {}
                    continue;
                    finally {
                        inconnection = null;
                        p = null;
                    }
                }
            }
            catch (Throwable t) {
                if (!GWDebug.debug.errorEnabled()) continue;
                GWDebug.debug.error("JSSProxyRunnable: Uncaught exception:", t);
            }
        }
    }

    private class JSSProxySessionRunnable
    implements Runnable {
        private Socket inconnection = null;
        private Socket toProxySocket = null;

        JSSProxySessionRunnable(Socket socket) {
            this.inconnection = socket;
        }

        public void run() {
            String replyStr;
            String host;
            ServiceReachabilityInfo sInfo;
            byte[] prebuffer;
            block26: {
                Integer remotePort = new Integer(this.inconnection.getPort());
                prebuffer = new byte[1];
                try {
                    DataInputStream inFrom = new DataInputStream(this.inconnection.getInputStream());
                    inFrom.readFully(prebuffer, 0, 1);
                }
                catch (IOException e) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("JSSProxySessionRunnable: Unable to open input stream on " + this.inconnection, e);
                    }
                    connectHashMap.remove(remotePort);
                    this.closeSockets();
                    return;
                }
                sInfo = (ServiceReachabilityInfo)connectHashMap.remove(remotePort);
                host = sInfo.getProxyHost();
                int port = sInfo.getProxyPort();
                try {
                    this.toProxySocket = new Socket(host, port);
                    this.toProxySocket.setTcpNoDelay(true);
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.incrementPlainSockets();
                    }
                }
                catch (Exception ex) {
                    this.toProxySocket = null;
                    if (!GWDebug.debug.errorEnabled()) break block26;
                    GWDebug.debug.error("JSSProxySessionRunnable: Unable to connect to " + host + ":" + port + ". " + ex);
                }
            }
            if (this.toProxySocket == null) {
                this.closeSockets();
                return;
            }
            String desthost = sInfo.getHost();
            String destport = Integer.toString(sInfo.getPort());
            OutputStream out = null;
            InputStream in = null;
            byte[] reply = new byte[200];
            int replyLen = 0;
            int newlinesSeen = 0;
            boolean headerDone = false;
            try {
                byte[] b;
                out = this.toProxySocket.getOutputStream();
                StringBuffer strsb = new StringBuffer();
                String msg = null;
                strsb.append("CONNECT ").append(desthost).append(":").append(destport).append(" HTTP/1.0\r\n").append("User-Agent: ").append(HttpURLConnection.userAgent);
                String authinfo = DomainWebProxyConfig.getProxyPassword(host);
                if (authinfo != null) {
                    strsb.append("\r\nProxy-Authorization: Basic ").append(authinfo).append("\r\n");
                } else {
                    strsb.append("\r\n\r\n");
                }
                msg = strsb.toString();
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message(msg);
                }
                try {
                    b = msg.getBytes("ASCII7");
                }
                catch (UnsupportedEncodingException ignored) {
                    b = msg.getBytes();
                }
                out.write(b);
                out.flush();
                in = this.toProxySocket.getInputStream();
                boolean error = false;
                while (newlinesSeen < 2) {
                    int i = in.read();
                    if (i < 0) {
                        if (GWDebug.debug.warningEnabled()) {
                            GWDebug.debug.warning("JSSProxySessionRunnable: Unexpected EOF from proxy");
                        }
                        this.closeSockets();
                        return;
                    }
                    if (i == 10) {
                        headerDone = true;
                        ++newlinesSeen;
                        continue;
                    }
                    if (i == 13) continue;
                    newlinesSeen = 0;
                    if (headerDone || replyLen >= reply.length) continue;
                    reply[replyLen++] = (byte)i;
                }
            }
            catch (IOException ioe) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("JSSProxySessionRunnable: Unable to get OutputStream" + ioe);
                }
                this.closeSockets();
                return;
            }
            try {
                replyStr = new String(reply, 0, replyLen, "ASCII7");
            }
            catch (UnsupportedEncodingException ignored) {
                replyStr = new String(reply, 0, replyLen);
            }
            if (!replyStr.startsWith("HTTP/1.0 200")) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("JSSProxySessionRunnable: Unable to tunnel through ");
                }
                this.closeSockets();
                return;
            }
            try {
                out.write(prebuffer);
                out.flush();
            }
            catch (IOException ioe) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("JSSProxySessionRunnable: Unable to write prebuffer." + ioe);
                }
                this.closeSockets();
                return;
            }
            new RWGroupJSSProxy(this.inconnection, this.toProxySocket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeSockets() {
            if (this.inconnection != null) {
                try {
                    this.inconnection.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        if (this.inconnection instanceof SSLSocket) {
                            SocketCount.decrementSSLSockets();
                        } else {
                            SocketCount.decrementPlainSockets();
                        }
                    }
                }
                catch (Exception e1) {
                }
                finally {
                    this.inconnection = null;
                }
            }
            if (this.toProxySocket != null) {
                boolean isHTTPS = this.toProxySocket instanceof SSLSocket;
                try {
                    this.toProxySocket.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        if (this.toProxySocket instanceof SSLSocket) {
                            SocketCount.decrementSSLSockets();
                        } else {
                            SocketCount.decrementPlainSockets();
                        }
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    this.toProxySocket = null;
                }
            }
        }
    }
}

