/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.CookieInfoContainer;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.util.SystemProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class CookieParser {
    private static final byte[] crlf = new byte[]{13, 10};
    private static final String scrlf = new String(crlf);
    private static final String SET_COOKIE = "Set-Cookie";
    private static String sessionCookieName;
    private static String gatewaySetCookieDomain;
    private static final boolean _useHTTPProxy;
    private static boolean setCookiesAsSecure;

    public static String modifyCookieHeader(HTTPResponse resp, Request req, String cookie_header) {
        if (cookie_header == null) {
            return null;
        }
        int index = cookie_header.indexOf(58);
        if (index == -1 || index + 1 == cookie_header.length()) {
            return cookie_header;
        }
        String cookie = cookie_header.substring(index + 1).trim();
        StringTokenizer tokens = new StringTokenizer(cookie, ";");
        if (!tokens.hasMoreTokens()) {
            return cookie_header;
        }
        String nameAndValue = tokens.nextToken().trim();
        if (nameAndValue.startsWith(sessionCookieName + "=")) {
            if (setCookiesAsSecure && req.getGatewayURL().regionMatches(true, 0, "https", 0, 5)) {
                cookie_header = cookie_header.trim();
                while (cookie_header.endsWith("\r") || cookie_header.endsWith("\n")) {
                    cookie_header = cookie_header.substring(0, cookie_header.length() - 1);
                }
                cookie_header = cookie_header.endsWith(";") ? cookie_header + "; secure" + scrlf : cookie_header + "; secure" + scrlf;
            }
            return cookie_header;
        }
        int equIndex = nameAndValue.indexOf(61);
        if (equIndex != -1) {
            String tmpValue = nameAndValue.substring(equIndex + 1);
            try {
                tmpValue = URLEncoder.encode(tmpValue);
                nameAndValue = nameAndValue.substring(0, equIndex + 1) + tmpValue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        StringBuffer sb = new StringBuffer();
        String path = null;
        String domain = null;
        boolean domainAppended = false;
        boolean pathAppended = false;
        String reqHost = req.getHost();
        String reqPath = req.getObject();
        int lastSlashIndex = reqPath.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            reqPath = "/";
        } else if (reqPath.length() > 1) {
            reqPath = reqPath.substring(0, lastSlashIndex + 1);
        }
        if (_useHTTPProxy) {
            reqHost = req.getURL();
            int tmpIndx = reqHost.indexOf(58) + 3;
            int tmpIndx1 = reqHost.indexOf(58, tmpIndx);
            int indxSlash = reqHost.indexOf(47, tmpIndx);
            if (indxSlash == -1) {
                indxSlash = reqHost.length();
                reqPath = "/";
            } else {
                reqPath = reqHost.substring(indxSlash);
            }
            reqHost = tmpIndx1 == -1 ? reqHost.substring(tmpIndx, indxSlash) : (indxSlash < tmpIndx1 ? reqHost.substring(tmpIndx, indxSlash) : reqHost.substring(tmpIndx, tmpIndx1));
        }
        while (tokens.hasMoreTokens()) {
            String val;
            String attr;
            String token = tokens.nextToken().trim();
            if (token.length() == 0) continue;
            equIndex = token.indexOf(61);
            if (equIndex < 0) {
                attr = token;
                val = null;
            } else {
                attr = token.substring(0, equIndex).trim();
                val = equIndex + 1 == token.length() ? null : token.substring(equIndex + 1).trim();
            }
            if (attr.equalsIgnoreCase("path")) {
                path = val;
                if (path == null || reqPath.startsWith(path)) continue;
                return null;
            }
            if (attr.equalsIgnoreCase("domain")) {
                domain = val;
                if (domain == null) continue;
                if (domain.length() < 3) {
                    return null;
                }
                if (domain.charAt(domain.length() - 1) == '.') {
                    return null;
                }
                if (reqHost.toLowerCase().endsWith(domain.toLowerCase())) continue;
                return null;
            }
            sb.append("; " + token);
        }
        StringBuffer sbnv = new StringBuffer(2 * nameAndValue.length());
        sbnv.append(SET_COOKIE).append(": ");
        if (path != null) {
            sbnv.append(URLEncoder.encode(path.replace('_', ';')));
        }
        if (domain != null) {
            sbnv.append(URLEncoder.encode(domain.replace('_', ';')));
        } else {
            sbnv.append(URLEncoder.encode(URLEncoder.encode(reqHost).replace('_', ';')));
        }
        sbnv.append("_");
        sbnv.append(nameAndValue);
        sbnv.append("|");
        String gwHost = SystemProperties.get("gateway.host", null);
        String reqGWHost = req.getGatewayHost();
        if (gwHost != null) {
            if (reqGWHost != null && !reqGWHost.equalsIgnoreCase(gwHost)) {
                try {
                    URL tmpUrl = new URL(req.getGatewayURL());
                    gwHost = tmpUrl.getHost();
                }
                catch (MalformedURLException ex) {}
            }
        } else {
            gwHost = reqGWHost;
        }
        if (gwHost != null && gwHost.indexOf(46) == gwHost.lastIndexOf(46)) {
            gwHost = null;
        }
        if (CookieParser.isAnIpAddress(gwHost)) {
            gwHost = null;
        }
        String gwDomain = null;
        if (gatewaySetCookieDomain != null) {
            gwDomain = gatewaySetCookieDomain;
            if (gwDomain.trim().length() == 0) {
                gwDomain = null;
            }
        } else if (gwHost != null && gwHost.indexOf(46) != -1) {
            gwDomain = gwHost.substring(gwHost.indexOf(46)).toLowerCase();
        }
        if (gwDomain != null) {
            sb.append("; domain=");
            sb.append(gwDomain);
        }
        if (domain != null) {
            sbnv.append(domain);
        } else {
            sbnv.append(reqHost.toLowerCase());
        }
        sbnv.append("|");
        sb.append("; path=/");
        if (path != null) {
            sbnv.append(path);
        } else {
            String s = reqPath;
            if (s == null) {
                sbnv.append("/");
            } else {
                int i = s.lastIndexOf(47);
                if (i < 1) {
                    sbnv.append("/");
                } else {
                    sbnv.append(s.substring(0, i));
                }
            }
        }
        if (setCookiesAsSecure && req.getGatewayURL().regionMatches(true, 0, "https", 0, 5)) {
            sb.append("; secure");
        }
        sbnv.append("|iplanet");
        sbnv.append(sb).append(scrlf);
        return sbnv.toString();
    }

    private static boolean isAnIpAddress(String host) {
        StringTokenizer octets = new StringTokenizer(host, ".");
        if (octets.countTokens() != 4) {
            return false;
        }
        while (octets.hasMoreTokens()) {
            String octet = octets.nextToken();
            if (octet.length() > 3) {
                return false;
            }
            for (int i = 0; i < octet.length(); ++i) {
                if (Character.isDigit(octet.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static void restoreCookieHeader(Request req) {
        List<CookieInfoContainer> list;
        String name;
        String cookie_header = req.getRequestHeader("Cookie");
        if (cookie_header == null) {
            return;
        }
        int index = cookie_header.indexOf(58);
        if (index == -1 || index + 1 == cookie_header.length()) {
            return;
        }
        String cookies = cookie_header.substring(index + 1).trim();
        StringTokenizer tokens = new StringTokenizer(cookies, ";");
        String reqHost = req.getHost();
        String reqPath = req.getObject();
        int lastSlashIndex = reqPath.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            reqPath = "/";
        } else if (reqPath.length() > 1) {
            reqPath = reqPath.substring(0, lastSlashIndex + 1);
        }
        if (_useHTTPProxy) {
            reqHost = req.getURL();
            int tmpIndx = reqHost.indexOf(58) + 3;
            int tmpIndx1 = reqHost.indexOf(58, tmpIndx);
            int indxSlash = reqHost.indexOf(47, tmpIndx);
            if (indxSlash == -1) {
                indxSlash = reqHost.length();
                reqPath = "/";
            } else {
                reqPath = reqHost.substring(indxSlash);
            }
            reqHost = tmpIndx1 == -1 ? reqHost.substring(tmpIndx, indxSlash) : (indxSlash < tmpIndx1 ? reqHost.substring(tmpIndx, indxSlash) : reqHost.substring(tmpIndx, tmpIndx1));
        }
        StringBuffer sb = new StringBuffer("Cookie:");
        Hashtable<String, LinkedList<CookieInfoContainer>> cookieTable = new Hashtable<String, LinkedList<CookieInfoContainer>>();
        while (tokens.hasMoreTokens()) {
            int valIndex;
            String token = tokens.nextToken().trim();
            if (!token.endsWith("|iplanet")) {
                sb.append(" " + token + ";");
                continue;
            }
            int index1 = token.indexOf("_");
            String st = token.substring(index1 + 1);
            if ((index1 = (token = st).lastIndexOf(124)) < 2) {
                sb.append(" ").append(token).append(";");
                continue;
            }
            int index2 = token.lastIndexOf(124, index1 - 1);
            if (index2 < 1) {
                sb.append(" ").append(token).append(";");
                continue;
            }
            int index3 = token.lastIndexOf(124, index2 - 1);
            if (index3 < 0) {
                sb.append(" ").append(token).append(";");
                continue;
            }
            if (index3 + 1 == index2 || index2 + 1 == index1) {
                sb.append(" ").append(token).append(";");
                continue;
            }
            String domain = token.substring(index3 + 1, index2).trim();
            String path = token.substring(index2 + 1, index1).trim();
            boolean domainCheck = false;
            domainCheck = reqHost.toLowerCase().endsWith(domain.toLowerCase());
            if (!domainCheck || !reqPath.startsWith(path)) continue;
            String orig_cookie = token.substring(0, index3).trim();
            if (orig_cookie.indexOf(37, index1 = orig_cookie.indexOf(61) + 1) != -1) {
                try {
                    String newValue = URLDecoder.decode(orig_cookie.substring(index1));
                    orig_cookie = orig_cookie.substring(0, index1) + newValue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if ((valIndex = orig_cookie.indexOf(61)) != -1) {
                name = orig_cookie.substring(0, valIndex);
                list = (List)cookieTable.get(name);
                if (list == null) {
                    list = new LinkedList<CookieInfoContainer>();
                    list.add(new CookieInfoContainer(orig_cookie, domain, path));
                    cookieTable.put(name, (LinkedList<CookieInfoContainer>)list);
                    continue;
                }
                list.add(new CookieInfoContainer(orig_cookie, domain, path));
                continue;
            }
            sb.append(" ").append(orig_cookie).append(";");
        }
        Set cookieSet = cookieTable.keySet();
        Iterator iter = cookieSet.iterator();
        while (iter.hasNext()) {
            name = (String)iter.next();
            list = (LinkedList<CookieInfoContainer>)cookieTable.get(name);
            sb.append(" ").append(CookieParser.findBestCookieMatch(list)).append(";");
        }
        int len = sb.length();
        if (sb.charAt(len - 1) == ';') {
            sb.setLength(len - 1);
        }
        req.setRequestHeader("Cookie", sb.toString() + scrlf);
    }

    private static String findBestCookieMatch(List cookieList) {
        Collections.sort(cookieList);
        StringBuffer sb = new StringBuffer();
        Iterator iter = cookieList.iterator();
        while (iter.hasNext()) {
            sb.append(((CookieInfoContainer)iter.next()).getCookie());
            if (!iter.hasNext()) continue;
            sb.append(" ; ");
        }
        return sb.toString();
    }

    static {
        gatewaySetCookieDomain = null;
        sessionCookieName = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
        gatewaySetCookieDomain = SystemProperties.get("gateway.setcookie.domain", null);
        _useHTTPProxy = GatewayProfile.getBoolean("UseHTTPProxy", false);
        setCookiesAsSecure = GatewayProfile.getBoolean("MarkCookiesSecure", false);
    }
}

